<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\RankRequest;
use App\Models\Rank;
use Illuminate\Http\Request;

class RankController extends Controller
{
    public function index(){
        $ranks = Rank::get();
        return view('admin.rank.index',compact('ranks'));
    }

    public function create(){
        return view('admin.rank.form',['rank'=>null]);
    }

    public function edit($id){
        $rank = Rank::where('id',$id)->firstOrFail();
        return view('admin.rank.form',compact('rank'));
    }

    public function delete($id){
        Rank::where('id',$id)->delete();
        toastr()->success('Rank deleted successfully');
        return redirect()->back();
    }

    public function store(RankRequest $rankRequest){
        $id= request('id');
        $data = [
            'name'=>$rankRequest->name,
            'type'=>$rankRequest->type,
            'team_A_amount'=>$rankRequest->team_A_amount,
            'team_B_amount'=>$rankRequest->team_B_amount,
        ];

        Rank::updateOrCreate(['id'=>$id],$data);
        toastr()->success('Rank has been saved successfully');
        return redirect()->route('admin.rank.index');
    }
}
