<?php

namespace App\Http\Controllers\Admin\MyStore;

use App\Http\Controllers\Controller;
use App\Models\FundRequest;
use Illuminate\Http\Request;

class FundController extends Controller
{
    public function requests(){
        $requests = FundRequest::with('hub')->get();
        return view('admin.my-store.fund.request',compact('requests'));
    }

    public function acceptRequest($id){
        $request = FundRequest::with('hub')->where('id', $id)->where('status',FUND_REQUEST_PENDING)->firstOrFail();
        $request->hub?->increment('fund_balance',$request->amount);
        $request->update(['status'=>FUND_REQUEST_ACCEPTED]);
        toastr()->success('Request Accepted Successfully');
        return redirect()->back();
    }

    public function rejectRequest(Request $request){
        $request = FundRequest::where('id', $request->id)->where('status',FUND_REQUEST_PENDING)->firstOrFail();
        $request->update(['reject_reason'=>$request->reject_reason]);
        toastr()->success('Request Rejected Successfully');
        return redirect()->back();
    }
}
