<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\ContactRequest;
use App\Models\Contact;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    public function index(){
        $contacts = Contact::get();
        return view('admin.contact.index',compact('contacts'));
    }

    public function create(){
        return view('admin.contact.form',['contact'=>null]);
    }

    public function edit($id){
        $contact = Contact::where('id',$id)->firstOrFail();
        return view('admin.contact.form',compact('contact'));
    }

    public function delete($id){
        Contact::where('id',$id)->delete();
        toastr()->success('Contact deleted successfully');
        return redirect()->back();
    }

    public function store(ContactRequest $contactRequest){

        $id= request('id');
        $data = [
            'title'=>$contactRequest->title,
            'value'=>$contactRequest->value,
            'link'=>$contactRequest->link,
        ];

        if($contactRequest->hasFile('icon')){
            $icon = imageUpload(
                $contactRequest->file("icon"),
                '/contact/'
            );
            $data["icon"] = $icon;
        }

        Contact::updateOrCreate(['id'=>$id],$data);
        toastr()->success('Contact has been saved successfully');
        return redirect()->route('admin.contact.index');
    }
}
