<?php
use App\Models\AppSettings;
use App\Models\Country;
use App\Models\OrderStatusHistory;
const ADMIN = 1;
const DELIVERY_HUB = 2;

const AGENT = 5;
const CUSTOMER = 6;
const ACTIVE=1;
const DEACTIVE=0;
const ACCEPTED=1;
const REJECTED=2;
const COMMISSION=1;
const WITHDRAWAL=2;
const ADD_MONEY=3;
const SHOW_IN_HOME=1;
const CASH_WALLET="cash_wallet";
const COMISSION_WALLET="comission_wallet";

const VENDOR_INACTIVE = 0;
const VENDOR_ACTIVE = 1;

const DELLER = 1;
const SELLER = 2;

const ORDER=3;
const BRAND = 'tbl_brand';
const COD = 'COD';
const BKASH = 'B';
const WALLET = 'W';

const ORDER_PENDING = 1;
const ORDER_ACCEPTED = 2;
const ORDER_REACHED_IN_DELIVERY_HUB = 3;
const ORDER_READY_FOR_DELIVERY = 4;
const ORDER_OUT_FOR_DELIVERY = 5;
const ORDER_DELIVERED = 6;
const ORDER_RETURNED = 7;
const ORDER_REFUNDED = 8;
const ORDER_CANCELLED = 9;

const NOT_REACHED_AT_HUB=0;
const REACHED_AT_LOCAL_HUB = 1;
const REACHED_AT_DELIVERY_HUB = 2;
const PRODUCT_CANCELLED =  3;
const RETURN_REQUEST = 4;
const RETURN__REQUEST_ACCEPTED = 5;
const RETURNED = 5;
const RETURN_REQUEST_CANCELLED = 6;

const TBL_DELIVERY_HUB = 'tbl_delivery_hub';


const RETURN_REQUEST_PENDING = 0;
const RETURN_REQUEST_ACCEPTED = 1;
const RETURN_REQUEST_REJECTED = 2;
const REFUNDED_BY_SELLER = 3;

const PRODUCT_THUMBNAIL_IMAGE = 1;
const PRODUCT_IMAGE = 2;

CONST OTP_RESEND_INTERVAL = 5;

CONST DELIVERY_INSIDE_DHAKA = ["6"];

CONST FUND_REQUEST_PENDING = 0;
CONST FUND_REQUEST_ACCEPTED = 1;
CONST FUND_REQUEST_REJECTED = 2;

CONST CUSTOMER_ORDER = 1;
CONST RESELLER_ORDER = 2;

use Illuminate\Support\Str;


function getFormInfo($isEditInfo, $others = [])
{
    if ($isEditInfo) {
        $info = ['title' => 'EDIT', 'status' => 'warning', 'button_name' => 'UPDATE', 'image_class' => 'edit-input'];
    } else {
        $info = ['title' => 'CREATE', 'status' => 'success', 'button_name' => 'CREATE', 'image_class' => ''];
    }
    return array_merge($info, $others);
}

function sideMenu()
{
    $path = base_path() . "/resources/views/theme/menu/admin-menu.json";
    $menu = json_decode(file_get_contents($path), true);

    return $menu;

}

function isActive($url)
{
    $browserUrl = request()->getRequestUri();
    if (Route::is($url)) {
        return 'active';
    }
}

function imageUpload($image, $folderPath)
{
    $file = $image;
    $extension = $file->getClientOriginalExtension();
    $fileName =  date('Y-m-d-H-i-s-U') . rand(123, 346) . '.' . $extension;
    $file->move(public_path().'/images' . $folderPath, $fileName);
    $filePath = $folderPath . $fileName;
    return $filePath;
}

function deleteImage($folderPath, $image)
{
    if (file_exists(public_path() . '/images/' . $folderPath . '' . $image)) {
        unlink(public_path() . '/images/' . $folderPath . '' . $image);
    }
}

function defaultLimit(){
    return 10;
}

function getStatuText($status){
    if($status == 1){
        return 'Published';
    }else{
        return 'Unpublished';
    }
}


function getGuardName(){
    $hostname = request()->getHost();
    if($hostname == 'admin.robiulawal.xyz'){
        return 'admin';
    }else if($hostname == 'deller.robiulawal.xyz'){
        return 'deller';
    }else{
        return 'admin';
    }
}

function getRole(){
    $hostname = request()->getHost();
    $data = [];
    if($hostname == 'admin.robiulawal.xyz'){
        return 'ADMIN';
    }else if($hostname == 'deller.robiulawal.xyz'){
        return 'Deller';
    }else{
        return 'ADMIN';
    }
}

function noImage(){
    return asset('images/no-image.jpg');
}

function serverError(){
    return redirect()->back()->withError('Something went wrong with you server , please try again');
}

function getPaymentMethod($paymentMethod){
    if($paymentMethod == COD){
        return 'Cash On Delivery';
    }else if($paymentMethod == BKASH){
        return 'Bkash';
    }else if($paymentMethod == WALLET){
        return 'Wallet';
    }
    else{
        return 'Comission';
    }
}

function getStatus($status){
    $orderStatus = [
        ORDER_PENDING => "Pending",
        ORDER_ACCEPTED => "Accepted",
        ORDER_READY_FOR_DELIVERY => "Ready for delivery",
        ORDER_OUT_FOR_DELIVERY => "Out for delivery",
        ORDER_REACHED_IN_DELIVERY_HUB => "Reached in delivery hub",
        ORDER_DELIVERED => "Delivered",
        ORDER_RETURNED => "Returned",
        ORDER_REFUNDED => "Refunded",
        ORDER_CANCELLED => "Cancelled",
    ];

    if(isset($orderStatus[$status])){
        return $orderStatus[$status];
    }else{
        return 'Undefined';
    }
}

function getStatusWithColor($status){
    $orderStatus = [
        ORDER_PENDING => "Pending",
        ORDER_ACCEPTED => "<span style='color:#dec400 !important'>Accepted</span>",
        ORDER_READY_FOR_DELIVERY => "Ready for delivery",
        ORDER_OUT_FOR_DELIVERY => "Out for delivery",
        ORDER_REACHED_IN_DELIVERY_HUB => "Reached in delivery hub",
        ORDER_DELIVERED => "<span style='color:green !important'>Delivered</span>",
        ORDER_RETURNED => "Returned",
        ORDER_REFUNDED => "Refunded",
        ORDER_CANCELLED => "<span style='color:red !important'>Cancelled</span>",
    ];

    if(isset($orderStatus[$status])){
        return $orderStatus[$status];
    }else{
        return 'Undefined';
    }
}

function getWithdrawalPending($status){
    if($status == 0){
        return '<b style="color:#FFC300">Pending</b>';
    }
    if($status == ACCEPTED){
        return '<b style="color:#228615">Accepted</b>';
    }
    if($status == REJECTED){
        return '<b style="color:#A21D1D">Rejected</b>';
    }
}

function getWithdrawalStatus($status){
    if($status == 0){
        return 'Pending';
    }
    if($status == ACCEPTED){
        return 'Accepted';
    }
    if($status == REJECTED){
        return 'Rejectd';
    }
}

function statusTimes($orderId){
    $data=(object)[
        'confirmed_time'=>OrderStatusHistory::where('order_id',$orderId)->where('status_id',ORDER_PENDING)->value('created_at'),
        'accepted_time'=>OrderStatusHistory::where('order_id',$orderId)->where('status_id',ORDER_ACCEPTED)->value('created_at'),
        'reached_time'=>OrderStatusHistory::where('order_id',$orderId)->where('status_id',ORDER_REACHED_IN_DELIVERY_HUB)->value('created_at'),
        'ready_for_delivery_time'=>OrderStatusHistory::where('order_id',$orderId)->where('status_id',ORDER_READY_FOR_DELIVERY)->value('created_at'),
        'out_for_delivery_time'=>OrderStatusHistory::where('order_id',$orderId)->where('status_id',ORDER_OUT_FOR_DELIVERY)->value('created_at'),
        'delivered_time'=>OrderStatusHistory::where('order_id',$orderId)->where('status_id',ORDER_DELIVERED)->value('created_at'),
    ];
    return $data;
}

function getOrderItemStatus($statusId){
    if($statusId == NOT_REACHED_AT_HUB){
        return 'No Reached Yet';
    }else if($statusId == REACHED_AT_LOCAL_HUB){
        return 'Reached at local hub';
    }else if($statusId == REACHED_AT_DELIVERY_HUB){
        return 'Reached at delivery hub';
    }else if($statusId == RETURN_REQUEST){
        return 'Requested for return';
    }else if($statusId == RETURN__REQUEST_ACCEPTED){
        return 'Return Request Accepted';
    }else if($statusId == RETURNED){
        return 'Returned';
    }else if($statusId == RETURN_REQUEST_CANCELLED){
        return 'Return Reequest Cancelled';
    }
}



function notRefundableStatus(){
    return [RETURN_REQUEST,RETURN__REQUEST_ACCEPTED,RETURNED,RETURN_REQUEST_CANCELLED];
}


function getItemsTotal($items){
    $total = 0;
    foreach ($items as $item) {
        $total += (float)$item->price*$item->qty;
    }
    return $total;
}

function orderTax(){
    return AppSettings::where('tag','order_tag')->value('value');
}

function maxComissionLevel(){
    return AppSettings::where('tag','comission_level')->value('value');
}

function comissionStatus(){
    return AppSettings::where('tag','comission_status')->value('value');
}
function maxLevelUser(){
    return AppSettings::where('tag','comission_limit')->value('value');
}
function smsStatus(){
    return AppSettings::where('tag','sms_status')->value('value');
}


function getValue($tag){
    return (int)AppSettings::where('tag',$tag)->value('value');
}


function getLang(){
    if(request('lang')){
        return request('lang');
    }else{
        return 'en';
    }
}


function orderPageTitle(){
    if(request('status')==ORDER_PENDING){
        return 'Pending Order List';
    }else if(request('status')==ORDER_DELIVERED){
        return 'Delivered Order List';
    }else if(request('in_progress')){
        return 'Inprogress Order List';
    }

    return 'List of all orders';
}

function strLimit($text,$limit){
   return Str::limit($text, $limit);
}

function getDashboardLink(){
    if(auth('user')->user()->role == ADMIN)
        return 'admin.dashboard';
    if(auth('user')->user()->role == SELLER)
        return 'seller.dashboard.index';
    if(auth('user')->user()->role == DELLER)
        return 'deller.dashboard.index';
}


function formatNumber($number) {
    if ($number < 1000) {
        return $number;
    } elseif ($number < 1000000) {
        return round($number / 1000, 1) . 'K';
    } elseif ($number < 1000000000) {
        return round($number / 1000000, 1) . 'M';
    } else {
        return round($number / 1000000000, 1) . 'B';
    }
}

function productType(){
    return [
        [
            "id"=>1,
            "name"=>"General",
        ],
        [
            "id"=>2,
            "name"=>"Joining",
        ],
        [
            "id"=>3,
            "name"=>"Re-purchase",
        ],
    ];
}




function numberformat(float $number){
    return number_format($number,2).'৳';
}


function taka(){
    return '৳';
}


function getRankTypes(){
    return [
        1=>'Sales Amount',
        2=>'Scenior Excecutive',
        3=>'Assistant Vice President',
        4=>'Vice President',
        5=>'Executive Vice President',
        6=>'President',
        7=>'Executive Director',
    ];
}
