@extends('admin.theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">ALL CASH WALLET REQUESTS</div>
    <div class="mi-body">
        <table class="table table-bordered mi-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>NAME</th>
                    <th>USER PHONE</th>
                    <th>PAYMNET METHOD</th>
                    <th>PAYMNET FROM</th>
                    <th>TRANSACTION ID</th>
                    <th>AMOUNT</th>
                    <th>ACTION</th>
                </tr>
            </thead>

            <tbody>
                @foreach($requests as $request)
                <tr>
                    <td>{{ $request->id }}</td>
                    <td>{{ $request?->user?->first_name. ' ' . $request?->user?->last_name }}</td>
                    <td>{{ $request?->user?->phone }}</td>
                    <td>{{ $request->phone }}</td>
                    <td>{{ $request->payment_method_name }}</td>
                    <td>{{ $request->transaction_id }}</td>
                    <td>{{ $request->amount }}</td>
                    <th class="mi-action-button">
                        <a onclick="return confirmBox({'status':'danger','title':'Are you sure to reject this request ? ','body':'Please check the transaction id before you reject this request'},event)" href="{{ route('cash-wallet.change-status',['id'=>$request->id,'status'=>2]) }}"><button class="butn butn-sm danger transparent" title="Reject Request"><i class="fa fa-times"></i></button></a>
                        <a onclick="return confirmBox({'status':'success','title':'Are you sure to accept this request ? ','body':'Please check the transaction id before you accept this request'},event)" href="{{ route('cash-wallet.change-status',['id'=>$request->id,'status'=>1]) }}"><button class="butn butn-sm success transparent" title="Accept Request"><i class="fa fa-check"></i></button></a>
                    </th>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="mi-fooer">

    </div>
</div>
@endsection
