<?php

use App\Http\Controllers\api\NotificationController;
use App\Http\Controllers\Shared\AuthController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/clear_cache', function () {
    // Clear the application cache
    Artisan::call('cache:clear');

    // Optionally, you can also clear other caches like config and route caches
    Artisan::call('config:clear');
    Artisan::call('route:clear');

    return 'Cache cleared successfully.';
});

Route::get('/', function () {
    return view('welcome');
});

Route::prefix('customer')->group(function () {
    Route::get('/', function () {
        return view('homes');
    });
});

Route::get('login',[AuthController::class,'loginForm'])->name('auth.login.form');
Route::post('login',[AuthController::class,'login'])->name('auth.login');
Route::get('logout',[AuthController::class,'logout'])->name('auth.logout');
Route::get('test-notification',[NotificationController::class,'testNotification']);

