<?php

use App\Http\Controllers\Seller\AuthController;
use App\Http\Controllers\Seller\DashboardController;
use App\Http\Controllers\Seller\ProductController;
use App\Http\Controllers\Seller\SellerController;
use App\Http\Controllers\Seller\ShopController;
use App\Http\Middleware\SellerAuth;
use Illuminate\Support\Facades\Route;

Route::as('auth.')->controller(AuthController::class)->group(function(){
    Route::get('login','loginForm')->name('login.form');
    Route::post('login/submit','login')->name('login');
    Route::get('logout','logout')->name('logout');
});


Route::middleware(SellerAuth::class)->group(function(){
    Route::prefix('dashboard')->as('dashboard.')->controller(DashboardController::class)->group(function(){
        Route::get('/','index')->name('index');
    });

    Route::prefix('profile')->as('profile.')->controller(SellerController::class)->group(function(){
        Route::get('edit','edit')->name('edit');
    });

    Route::prefix('shop')->as('shop.')->controller(ShopController::class)->group(function(){
        Route::get('edit','edit')->name('edit');
        Route::post('update','update')->name('update');
    });

    Route::prefix('product')->as('product.')->controller(ProductController::class)->group(function(){
        Route::get('list','list')->name('list');
        Route::get('create','create')->name('create');
        Route::get('edit/{id}','edit/{id}')->name('edit/{id}');
        Route::get('delete/{id}','delete/{id}')->name('delete/{id}');
        Route::post('store','store')->name('store');
    });

});
