<?php

use App\Http\Controllers\api\WalletControler;
use App\Http\Controllers\Hub\AuthController;
use App\Http\Controllers\Hub\DashboardController;
use App\Http\Controllers\Hub\FundController;
use App\Http\Controllers\Hub\HubController;
use App\Http\Controllers\Hub\OrderController;
use App\Http\Controllers\Hub\WalletController;
use App\Http\Controllers\Hub\WithdrawControler;
use App\Http\Middleware\HubAuth;
use Illuminate\Support\Facades\Route;

Route::as('auth.')->controller(AuthController::class)->group(function(){
    Route::get('login','loginForm')->name('login.form');
    Route::post('login/submit','login')->name('login');
    Route::get('logout','logout')->name('logout');
});
Route::middleware(HubAuth::class)->group(function(){
    Route::middleware(HubAuth::class)->group(function(){
        Route::prefix('dashboard')->as('dashboard.')->controller(DashboardController::class)->group(function(){
            Route::get('/','index')->name('index');
        });

        Route::prefix('fund')->as('fund.')->controller(FundController::class)->group(function(){
            Route::get('/','index')->name('index');
            Route::get('/request','create')->name('create');
            Route::get('/request/{id}','edit')->name('edit');
            Route::post('/request','store')->name('store');
            Route::get('/delete/{id}','delete')->name('delete');
        });

        Route::prefix('order')->as('order.')->controller(OrderController::class)->group(function(){
            Route::get('/mystore','myStoreOrder')->name('myStoreOrder');
            Route::get('/','index')->name('index');
            Route::get('details','details')->name('details');
            Route::get('/request/{id}','edit')->name('edit');
            Route::post('/request','store')->name('store');
            Route::get('/delete/{id}','delete')->name('delete');
            Route::get('/change-status/{order_id}/{status}','changeStatus')->name('change-status');
            Route::post('/change-item-status/{order_item_id}','changeItemStatus')->name('change-item-status');
        });

        Route::prefix('wallet-history')->as('wallet-history.')->controller(WalletController::class)->group(function(){
            Route::get('fund','fund')->name('fund');
            Route::get('cod','cod')->name('cod');
            Route::get('commission','commission')->name('commission');
            Route::post('transfer-cod-to-fund','transferCodToFund')->name('transfer.cod-to-fund');
            Route::post('transfer-comission-to-fund','transferCommissionToFund')->name('transfer.comission-to-fund');
            // Route::get('/request','create')->name('create');
        });
        Route::prefix('withdraw')->as('withdraw.')->controller(WithdrawControler::class)->group(function(){
            Route::get('','index')->name('index');
            Route::post('store','store')->name('store');
        });
    });

});
