<?php

use App\Http\Controllers\Deller\AuthController;
use App\Http\Controllers\Deller\DashboardController;
use App\Http\Middleware\DellerAuth;
use Illuminate\Support\Facades\Route;

Route::as('auth.')->controller(AuthController::class)->group(function(){
    Route::get('login','loginForm')->name('login.form');
    Route::post('login/submit','login')->name('login');
    Route::get('logout','logout')->name('logout');
});

Route::middleware(DellerAuth::class)->group(function(){
    Route::prefix('dashboard')->as('dashboard.')->controller(DashboardController::class)->group(function(){
        Route::get('/','index')->name('index');
    });
});
