<?php

use App\Http\Controllers\admin\DeliveryHubController;
use App\Http\Controllers\api\AddressController;
use App\Http\Controllers\api\CartController;
use App\Http\Controllers\Api\LeadershipController;
use App\Http\Controllers\api\NotificationController;
use App\Http\Controllers\api\OrderControler;
use App\Http\Controllers\api\ProductControler;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\api\WalletControler;
use App\Http\Controllers\auth\AuthController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\LocationController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });



Route::prefix('user')->group(function () {
    Route::get('payment-methods/add-money',[WalletControler::class,'getAddMoneyPaymentMethods'])->name('add-money-payment-methods');
    Route::get('/', [UserController::class, 'index'])->name('home');
    // Route::get('/f', [UserController::class, 'jndex']);
    Route::controller(AuthController::class)->group(function(){
        Route::post('/signin', 'signIn')->name('signIn');
        Route::post('/signup', 'signUp')->name('signUp');
        Route::get('test',[AuthController::class,'test'])->name('auth.login.test');
        Route::get('/generate-otp', 'generateOtp')->name('generate-otp');
        Route::get('/verify-phone', 'showVerificationPage')->name('show-verification');
        Route::post('/verify-phone', 'verifyPhone')->name('verify-phone');
    });

    Route::controller(ForgotPasswordController::class)->as('forgot-password.')->prefix('forgot-password')->group(function(){
        Route::post('send-otp', 'sendOtp')->name('send-otp');
        Route::post('verify', 'verifyOtp')->name('send-otp');
        Route::post('reset-password', 'resetPassword')->name('reset-passwordb ');
        Route::get('test', 'test')->name('send-otp');
    });




    Route::get('/home-page-data', [ProductControler::class, 'getHomePageData'])->name('home-page-data');
    Route::get('/products', [ProductControler::class, 'getProductInGroup']);
    Route::post('/cart-items', [CartController::class, 'getCartItems']);
    Route::get('/products/info', [ProductControler::class, 'getProductInfo']);
    Route::get('/products/basic-info', [ProductControler::class, 'productBasicInfo']);
    Route::get('product/details/{id}', [ProductControler::class, 'getProductDetails']);
    Route::get('product/mystore', [ProductControler::class, 'getMyStoreProduct']);
    Route::get('/category-products', [ProductControler::class, 'getCategoryProducts']);
    Route::get('/categories', [ProductControler::class, 'getCategories']);
    Route::get('/shops', [ProductControler::class, 'getShops']);
    Route::post('/coupon/apply', [OrderControler::class, 'applyCoupon']);
    Route::get('/charges', [OrderControler::class, 'getCharges'])->name('charges');



    Route::get('/return/list', [OrderControler::class, 'returnRequests']);



    Route::get('products/offer/{offerId}', [ProductControler::class, 'getOfferProduts']);
    // Authenticated Routes goes here

    Route::middleware('auth:sanctum')->group(function () {
        Route::get('/f', [UserController::class, 'jndex'])->name('user-data');

        Route::prefix('order')->as('order.')->controller(OrderControler::class)->group(function(){
            Route::get('list', 'getOrderListForUser')->name('list');
            Route::get('details/{id}', 'getOrderDetails')->name('details');
            Route::get('cancel/{id}', 'cancelOrder')->name('cancel');
            Route::post('place', 'placeOrder')->name('place');
        });

        Route::as('wallet.')->controller(WalletControler::class)->group(function(){
            Route::get('/cash-wallet-history', 'cashWalletHistory');
            Route::get('/commission-wallet-history', 'commissionWalletHistory');
            Route::get('/withdraw-request', 'withdrawRequests');
            Route::post('/add-money', 'addMoneyFromBkashToWallet');
            Route::post('/withdraw-money', 'withdrawMoney');
            Route::get('/balance', 'getWalletBalance');
        });

        Route::controller(AuthController::class)->group(function(){
            Route::put('/update-profile', 'updateProfile')->name('profile.update');
            Route::get('/profile', 'userDetails')->name('profile.details');
            Route::get('/reffer-link/{type}', 'refferLink')->name('reffer-link');
            Route::post('/logout', 'logout')->name('logout');
            Route::get('/referrals', 'getReferrals')->name('referrals');
            Route::get('teams', 'getTeam')->name('teams');
        });

        Route::prefix('notification')->as('notification.')->controller(NotificationController::class)->group(function(){
            Route::get('list','index')->name('list');
            Route::get('count','checkNotification')->name('notification-check');
            Route::get('mark-as-read','markAsRead')->name('mark-as-read');
        });

        Route::prefix('address')->as('address.')->controller(AddressController::class)->group(function(){
            Route::get('list/{type}','list')->name('list');
            Route::get('default/{type}','defaultAddress')->name('default');
            Route::post('store','store')->name('store');
            Route::post('select-shipping-address','selectShippingAddress')->name('select-shipping-address');
            Route::get('edit/{id}','edit')->name('edit');
            Route::get('delete/{id}','delete')->name('delete');
            Route::get('divisions','divisions')->name('divisions');
        });

        Route::as('menu.')->controller(UserController::class)->group(function(){
            Route::get('sponsors','sponsors')->name('sponsors');
            Route::get('team','team')->name('team');
            Route::get('leadership','leadership')->name('leadership');
            Route::get('ranks','ranks')->name('ranks');
            Route::get('contacts','contact')->name('contact');
            Route::get('earn-money','earnMoney')->name('earnMoney');
        });

        Route::prefix('leadership')->as('leadership.')->controller(LeadershipController::class)->group(function(){
            Route::get('list','list')->name('list');
            Route::post('upgrade','upgrade')->name('upgrade');
        });



        Route::post('/return/request', [OrderControler::class, 'returnItem']);
    });
});


Route::controller(ProductControler::class)->group(function(){
    Route::get('/subcategories/{category_id}', 'getSubcategoryByCategory')->name('subcategories');
    Route::get('/brands/{company_id}', 'getBrands')->name('getBrands');
    Route::get('/basic-products','getProductBasicInfo')->name('basic-info');
});


Route::get('/districts/{division_id}', [LocationController::class, 'districts'])->name('districts');
Route::get('/upazilas/{district_id}', [LocationController::class, 'districts'])->name('districts');
Route::get('payment-methods/add-money',[WalletControler::class,'getAddMoneyPaymentMethods'])->name('add-money-payment-methods');
Route::get('limit/withdrawal',[WalletControler::class,'getWithdarwalLimit'])->name('wirhdrawal limit');
