<?php

use App\Http\Controllers\Admin\AdminWalletController;
use App\Http\Controllers\admin\AuthController;
use App\Http\Controllers\admin\BannerController;
use App\Http\Controllers\admin\BrandController;
use App\Http\Controllers\admin\ColorsController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\admin\CouponController;
use App\Http\Controllers\admin\DashboardController;
use App\Http\Controllers\admin\DeliveryHubController;
use App\Http\Controllers\admin\DellerController;
use App\Http\Controllers\admin\DellerShopController;
use App\Http\Controllers\Admin\FlashWalletController;
use App\Http\Controllers\admin\GlobalController;
use App\Http\Controllers\admin\GroupProductController;
use App\Http\Controllers\Admin\MyStore\FundController;
use App\Http\Controllers\admin\OfferController;
use App\Http\Controllers\admin\ProductBasicController;
use App\Http\Controllers\admin\ProductCategoryController;
use App\Http\Controllers\admin\ProductController;
use App\Http\Controllers\admin\ProductSubcategoryController;
use App\Http\Controllers\admin\ReportController;
use App\Http\Controllers\admin\SellerController;
use App\Http\Controllers\admin\OrderController;
use App\Http\Controllers\admin\ReturnController;
use App\Http\Controllers\admin\SitemapController;
use App\Http\Controllers\admin\SizesController;
use App\Http\Controllers\admin\UserController;
use App\Http\Controllers\admin\WithdrawalController;
use App\Http\Controllers\admin\WalletController;
use App\Http\Controllers\Admin\MyStore\LocationController;
use App\Http\Controllers\Admin\MyStore\PackageController;
use App\Http\Controllers\Admin\MyStore\ProductController as MyStoreProductController;
use App\Http\Controllers\Admin\MyStore\StockistAreaController;
use App\Http\Controllers\Admin\RankController;
use App\Http\Controllers\AppSettingsController;
use App\Http\Middleware\AdminMiddleware;
use App\Models\AppSettings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::controller(AuthController::class)->as('admin.auth.')->group(function(){
    Route::get('login','loginForm')->name('login.form');
    Route::post('login/submit','login')->name('login');
    Route::get('logout','logout')->name('logout');
});
Route::middleware([AdminMiddleware::class])->group(function(){

    Route::get('dashboard',[DashboardController::class,'index'])->name('admin.dashboard');


    Route::prefix('banner')->as('banner.')->controller(BannerController::class)->group(function(){
        Route::post('store','store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('app-popup', 'appPopup')->name('app-popup');
        Route::get('create', 'create')->name('create');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });


    Route::prefix('color')->controller(ColorsController::class)->as('color.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });


    Route::prefix('size')->controller(SizesController::class)->as('size.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });


    Route::prefix('product-category')->controller(ProductCategoryController::class)->as('product-category.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
        Route::get('delete/image/{id}', 'deleteImage')->name('delete-image');
    });

    Route::prefix('product-brand')->controller(BrandController::class)->as('product-brand.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });


    Route::prefix('product-basic-info')->controller(ProductBasicController::class)->as('product-basic-info.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
        Route::get('delete/image/{id}', 'deleteImage')->name('delete-image');
    });



    Route::prefix('product-subcategory')->controller(ProductSubcategoryController::class)->as('product-subcategory.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });


    Route::prefix('product')->controller(ProductController::class)->as('product.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::get('select', 'selectProduct')->name('select');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('details/{id}', 'details')->name('details');
        Route::get('delete/{id}', 'delete')->name('delete');
        Route::get('delete/color/{id}', 'deleteColor')->name('delete.color');
    });


    Route::prefix('coupon')->controller(CouponController::class)->as('coupon.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });


    Route::prefix('offer')->controller(OfferController::class)->as('offer.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });

    Route::prefix('group-product')->controller(GroupProductController::class)->as('group-product.')->group(function(){
        Route::get('', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });

    Route::prefix('withdrawal')->controller(WithdrawalController::class)->as('withdrawal.')->group(function(){
        Route::get('list', 'list')->name('list');
        Route::post('change-status/{id}/{status}', 'changeStatus')->name('change-status');
    });


    Route::prefix('deller')->controller(DellerController::class)->as('deller.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });

    Route::prefix('seller')->controller(SellerController::class)->as('seller.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });

     Route::prefix('return')->controller(ReturnController::class)->as('return.')->group(function(){
        Route::get('list', 'list')->name('list');
        Route::get('view/{id}', 'view')->name('view');
        Route::post('change-status', 'changeStatus')->name('change-status');
        Route::get('refunded/{id}', 'refunded')->name('refunded');
    });


    Route::prefix('delivery-hub')->controller(DeliveryHubController::class)->as('delivery-hub.')->group(function(){
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('list', 'list')->name('list');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });

    Route::prefix('user')->controller(UserController::class)->as('user.')->group(function(){
        Route::get('customer', 'customer')->name('customer');
        Route::get('agent', 'agent')->name('agent');
        Route::get('transaction-history', 'transactionHistory')->name('transaction-history');
        Route::get('referral/{id}', 'getReferrals')->name('referral');
        Route::get('transaction/{id}', 'getTransactions')->name('transaction');
        Route::get('change-status/{user_id}/{status}', 'changeStatus')->name('change-status');
        Route::get('delete/{user_id}', 'delete')->name('delete');
    });


    Route::prefix('order')->controller(OrderController::class)->as('order.')->group(function(){
        Route::get('list', 'list')->name('list');
        Route::get('customer/list', 'list')->name('customer.list');
        Route::get('agent/list', 'list')->name('agent.list');
        Route::get('dropshipper/list', 'list')->name('dropshipper.list');
        Route::get('deliveryhub/list', 'list')->name('deliveryhub.list');
        Route::get('view/{id}', 'view')->name('view');
        Route::get('change-status/{order_id}/{status}', 'changeOrderStatus')->name('status.change');
        Route::post('change-item-status/{order_item_id}', 'changeItemStatus')->name('item-status-change');
    });

    Route::prefix('global')->controller(GlobalController::class)->as('global.')->group(function(){
        Route::get('change-status/{table}/{id}/{status}', 'changeStatus')->name('change-status');
        Route::get('change-password', 'changePasswordForm')->name('change-password.form');
        Route::post('change-password', 'changePassword')->name('change-password');
    });


    Route::prefix('report')->controller(ReportController::class)->as('report.')->group(function(){
        Route::get('customer/sales-report', 'customerSalesReport')->name('customer.sales-report');
    });




    Route::prefix('sitemap')->controller(SitemapController::class)->as('sitemap.')->group(function(){
        Route::get('index', 'index')->name('index');
    });

    Route::prefix('app-settings')->controller(AppSettingsController::class)->as('app-settings.')->group(function(){
        Route::get('index', 'index')->name('app.index');
        Route::post('update', 'update')->name('app.update');
        Route::get('comission', 'comission')->name('comission');
        Route::get('delete-image/{tag}', 'deleteImage')->name('delete-image');
        Route::post('comission/update', 'updateComission')->name('comission.update');
    });

    Route::prefix('wallet-history')->controller(WalletController::class)->as('wallet-history.')->group(function(){
        Route::get('comission', 'comissionWalletHistory')->name('comission');
        Route::get('flash-wallet', 'flashWallet')->name('flash-wallet');
    });


    Route::prefix('cash-wallet')->controller(WalletController::class)->as('cash-wallet.')->group(function(){
        Route::get('request', 'walletRequests')->name('wallet-request');
        Route::get('change-status/{id}/{status}', 'changeStatus')->name('change-status');
    });

    Route::prefix('rank')->controller(RankController::class)->as('admin.rank.')->group(function(){
        Route::get('', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });
    Route::prefix('contact')->controller(ContactController::class)->as('admin.contact.')->group(function(){
        Route::get('', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('delete/{id}', 'delete')->name('delete');
    });

    Route::prefix('my-store')->as('admin.mystore.')->group(function(){
        Route::prefix('location')->controller(StockistAreaController::class)->as('location.')->group(function(){
            Route::get('','index')->name('index');
            Route::get('create','create')->name('create');
            Route::post('store','store')->name('store');
            Route::get('edit/{id}','edit')->name('edit');
            Route::get('delete/{id}','delete')->name('delete');
            Route::get('stockist','stockist')->name('stockist');
            Route::get('stockist/assign/{id}','assign')->name('assign');
            Route::post('stockist/assign/store/{id}','assignStore')->name('assign.store');
        });

        Route::prefix('fund')->controller(FundController::class)->as('fund.')->group(function(){
            Route::get('requests','requests')->name('requests');
            Route::get('accept-request/{id}','acceptRequest')->name('accept-request');
            Route::post('reject-request','rejectRequest')->name('reject-request');
        });
        Route::prefix('product')->controller(MyStoreProductController::class)->as('product.')->group(function(){
            Route::get('','index')->name('index');
            Route::get('create','create')->name('create');
            Route::get('edit/{id}','edit')->name('edit');
            Route::get('delete/{id}','delete')->name('delete');
            Route::post('store','store')->name('store');
        });
        Route::prefix('package')->controller(PackageController::class)->as('package.')->group(function(){
            Route::get('','index')->name('index');
            Route::get('create','create')->name('create');
            Route::get('edit/{id}','edit')->name('edit');
            Route::get('delete/{id}','delete')->name('delete');
            Route::post('store','store')->name('store');
        });
    });
    Route::prefix('flash-wallet')->controller(FlashWalletController::class)->as('admin.flash-wallet.')->group(function(){
        Route::get('transaction/{type}','transaction')->name('transaction');
        Route::post('withdrawal/{type}/withdraw','withdrawAmount')->name('withdrawal.withdraw');
        Route::get('withdrawal/{type}','withdrawal')->name('withdrawal');
        Route::get('sponsor-royalti/distribute','distributeSponsorRoyalti')->name('sponsor-royalti.distribute');
        Route::get('sponsor-royalti/capable-users','capableSponsorsRoyaltiUsers')->name('sponsor-royalti.capable-users');
    });
    Route::prefix('admin-wallet')->controller(AdminWalletController::class)->as('admin.admin-wallet.')->group(function(){
        Route::get('transaction/{type}','transaction')->name('transaction');
        Route::post('withdrawal/{type}/withdraw','withdrawAmount')->name('withdrawal.withdraw');
        Route::get('withdrawal/{type}','withdrawal')->name('withdrawal');
        Route::get('sponsor-royalti/distribute','distributeSponsorRoyalti')->name('sponsor-royalti.distribute');
    });
});










// Route::get('delivery-hub/create', [DeliveryHubController::class, 'create'])->name('delivery-hub.create');
// Route::post('delivery-hub/store', [DeliveryHubController::class, 'store'])->name('delivery-hub.store');
// Route::get('delivery-hub/list', [DeliveryHubController::class, 'list'])->name('delivery-hub.list');
// Route::get('delivery-hub/view', [DeliveryHubController::class, 'list'])->name('delivery-hub.view');
// Route::get('delivery-hub/edit/{id}', [DeliveryHubController::class, 'edit'])->name('delivery-hub.edit');
// Route::get('delivery-hub/delete/{id}', [DeliveryHubController::class, 'delete'])->name('delivery-hub.delete');

// Route::get('deller-shop/create', [DellerShopController::class, 'create'])->name('deller-shop.create');
// Route::post('deller-shop/store', [DellerShopController::class, 'store'])->name('deller-shop.store');
// Route::get('deller-shop/list', [DellerShopController::class, 'list'])->name('deller-shop.list');
// Route::get('deller-shop/view', [DellerShopController::class, 'list'])->name('deller-shop.view');
// Route::get('deller-shop/edit/{id}', [DellerShopController::class, 'edit'])->name('deller-shop.edit');
// Route::get('deller-shop/delete/{id}', [DellerShopController::class, 'delete'])->name('deller-shop.delete');

