@extends('theme.theme')
@section('content')
    <div class="mi-card" id="app">
        <div class="mi-header warning transparent">Edit Your Shop Information</div>
        <form action="{{ route('seller.shop.update') }}" method="post" enctype="multipart/form-data">
            <div class="mi-body">
                @csrf
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label for="shopLogo">Shop Logo <b class="text-danger">*</b></label>
                            <image-component imageurl="{{ $shop->shop_logo_url }}" />
                        </div>
                    </div>
                    <div class="col-sm-9">
                        <div class="row">
                            <div class="col-sm-6 form-group">
                                <label for="">Shop name (English) <b class="text-danger">*</b></label>
                                <input type="text" name="shop_name_en" id="shop_name_en" class="form-control" value="{{ $shop->shop_name_en }}" required>
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="">Shop name (Bangla) <b class="text-danger">*</b></label>
                                <input type="text" name="shop_name_bn" id="shop_name_bn" class="form-control" value="{{ $shop->shop_name_bn }}" required>
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="">Shop Address <b class="text-danger">*</b></label>
                                <input type="text" name="shop_address" id="shop_address" class="form-control" value="{{ $shop->shop_address }}" required>
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="">Phone Number <b class="text-danger">*</b></label>
                                <input type="text" name="phone" id="phone" class="form-control" value="{{ $shop->phone }}" required>
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="">Latitude <b class="text-danger">*</b></label>
                                <input type="text" name="lat" id="lat" class="form-control" value="{{ $shop->lat }}" required>
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="">Longitude <b class="text-danger">*</b></label>
                                <input type="text" name="lon" id="lon" class="form-control" value="{{ $shop->lon }}" required>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="mi-footer d-flex justify-content-end">
                <button type="submit" class="butn warning">Update</button>
            </div>
        </form>
    </div>

{{-- <script>
     function initMap() {
        var initialLatLng = { lat: 51.505, lng: -0.09 };
        var map = new google.maps.Map(document.getElementById('map'), {
            zoom: 13,
            center: initialLatLng
        });

        var marker = new google.maps.Marker({
            position: initialLatLng,
            map: map,
            draggable: true
        });

        google.maps.event.addListener(marker, 'dragend', function(event) {
            document.getElementById('latitude').value = event.latLng.lat();
            document.getElementById('longitude').value = event.latLng.lng();
        });
    }
</script> --}}
{{-- <script async defer src="https://maps.googleapis.com/maps/api/js?v=3&key=AIzaSyAmSBYC_cRf98cT369l7w_hOpp02DeDtRg&callback=initMap"></script> --}}

@endsection
