<style>
.select2-container {
    z-index: 9999;
}
</style>
<div>
    <div class="form-group">
        <div class="row">
            <div class="col-sm-12">
                <div class="form-group">
                    {{ $payment_method }}
                    <label for="">Please enter the amount you to withdraw</label>
                    <div class="input-group">
                        <input type="text" class="form-control" placeholder="Transfer Amount" aria-label="Amount"
                            aria-describedby="basic-addon1" name="amount" required>
                        <span class="input-group-text" id="basic-addon1">{{ taka() }}</span>
                    </div>
                </div>
                <div class="form-group">
                    <label for="">Select Payment Method</label>
                    <v-select :options="options"></v-select>
                    <select name="payment_method" id="payment_method">
                        <option value="Bkash">Bkash</option>
                        <option value="Nogad">Nogad</option>
                        <option value="Bank">Bank</option>
                    </select>
                </div>
            </div>

            @if($payment_method == 'Bkash' || $payment_method == 'Nogad')
            <div class="col-sm-8">
                <div class="form-group">
                    <label for="">Number</label>
                    <input type="number" name="number" id="number" class="form-control">
                </div>
            </div>

            <div class="col-sm-4">
                <div class="form-group">
                    <label for="">Type</label>
                    <select name="type" id="type" class="form-control">
                        <option value="Bkash">Agent</option>
                        <option value="Nogad">Personal</option>
                    </select>
                </div>
            </div>
            @else
                <div class="col-sm-12">
                    <div class="form-group">
                        <label for="">Bank Name</label>
                        <input type="number" name="data['bank_name']" id="bank_name" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Branch Location</label>
                        <input type="number" name="data['bank_location']" id="bank_name" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Account Number</label>
                        <input type="number" name="data['account_number']" id="account_number" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Account Holer Name</label>
                        <input type="number" name="data['account_holder_name']" id="bank_name" class="form-control">
                    </div>
                </div>
            @endif
        </div>

    </div>
</div>

<script>
    document.addEventListener('livewire:load', function () {
        $('#payment_method').select2();
        $('#payment_method').on('change', function (e) {
            const selectedValue = $(this).val();
            @this.set('payment_method', selectedValue);
            Livewire.emit('updatePaymentMethodValue', selectedValue); // Trigger Livewire method
        });

        Livewire.hook('message.processed', (message, component) => {
            $('#payment_method').select2();
        });
    })
</script>
