@extends('hub.theme.theme')
@section('content')
    <div class="mi-card">
        <div class="mi-header">
            WITHDRAWAL REQUESTS

            <div class="mi-right d-flex gap-3 align-items-center">
                BALANCE : {{ number_format(auth('hub')->user()->commission_balance, 2) }}{{ taka() }}
                <button class="butn danger" data-bs-toggle="modal" data-bs-target="#withdrawModal">MAKE A REQUEST</button>
            </div>
        </div>
        <div class="mi-body">
            <table class="table table-bordered mi-table">
                <thead>
                    <tr>

                        <th>#</th>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Payment Method</th>
                        <th>Details</th>
                        <th>Admin Reason</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($withdrawals as $key => $withdraw)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ Carbon\Carbon::parse($withdraw->created_at)->format('d M Y') }}</td>
                            <td>{{ number_format($withdraw->amount, 2) }}{{ taka() }}</td>
                            <td>{{ $withdraw->payment_method }}</td>
                            <td>
                                @if($withdraw->payment_method !== 'Bank')
                                    <p><b>Number</b> : {{ $withdraw->data['number'] }}</p>
                                    <p><b>Type</b> : {{ $withdraw->data['type'] }}</p>
                                @else
                                    <p><b>Bank Name</b> : {{ $withdraw->data['bank_name'] }}</p>
                                    <p><b>Branch Location</b> : {{ $withdraw->data['bank_location'] }}</p>
                                    <p><b>Account Number</b> : {{ $withdraw->data['account_number'] }}</p>
                                    <p><b>Account Holder Namne</b> : {{ $withdraw->data['account_holder_name'] }}</p>
                                @endif
                            </td>
                            <td>{{ $withdraw->admin_reason ?? 'N/A' }}</td>
                            <td>{{ $withdraw->status_text }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @include('hub.withdraw.form')
@endsection
