@extends('hub.theme.theme')
@section('content')
@include('hub.wallet')
<div class="row">
    <div class="mi-card">
        <div class="mi-header">{{ $title }}

            @if(Route::is('hub.wallet-history.cod'))
                <button class="butn danger mi-right" data-bs-toggle="modal" data-bs-target="#transferModal">TRANSFER</button>
            @endif
        </div>
        <div class="mi-body">
            <table class="table table-bordered mi-table" id="dataTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>DATE</th>
                        <th>AMOUNT</th>
                        <th>ORDER NUMBER</th>
                        <th>MESSAGE</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($histories as $history)
                        <tr>
                            <td>{{ $history->id }}</td>
                            <td>{{ $history->created_at?->format('d M Y h:i a') }}</td>
                            <td>{{ number_format($history->amount, 2) }}{{ taka() }}</td>
                            <td>{{ $history->order?->order_number ? '#'.$history->order?->order_number :'N/A'  }}</td>
                            <td>{{ $history->message }}</td>
                        </tr>
                    @endforeach
                </tbody>

            </table>
        </div>
    </div>
</div>
@include('hub.wallet-history.transfer-modal',['action'=>route('hub.wallet-history.transfer.cod-to-fund')])
@endsection
