@extends('hub.theme.theme')
@section('content')
    @include('hub.wallet')

    <div class="row">
        <div class="mi-card">
            <div class="mi-header">
                Comission Balance History
                <button class="butn danger mi-right" data-bs-toggle="modal" data-bs-target="#transferModal">TRANSFER</button>
            </div>
            <div class="mi-body">
                <table class="table table-bordered mi-table" id="dataTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>DATE</th>
                            <th>TYPE</th>
                            <th>AMOUNT</th>
                            <th>ORDER NUMBER</th>
                            <th>MESSAGE</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($commissions as $commission)
                            <tr>
                                <td>{{ $commission->id }}</td>
                                <td>{{ Carbon\Carbon::parse($commission->created_at)->format('d M Y h:i a') }}</td>
                                <td>{{ $commission->commission_status }}</td>
                                <td>{{ number_format($commission->amount, 2) }}{{ taka() }}</td>
                                <td>{{ $commission->order?->order_number ? '#' . $commission->order?->order_number : 'N/A'  }}</td>
                                <td>{{ $commission->message }}</td>
                            </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div

    @include('hub.wallet-history.transfer-modal', ['action' => route('hub.wallet-history.transfer.comission-to-fund')])

@endsection
