<ul>
    @php
$path = base_path() . "/resources/views/hub/theme/hub-menu.json";
$menu = json_decode(file_get_contents($path), true);
    @endphp
    @foreach($menu as $item)
        <li>
            @if(isset($item['children']))
                <a class="dropdown d-flex align-items-center gap-2"><img style="width:25px" src="{{ asset('images/hub/icons/' . $item['icon']) }}" alt=""> <span class="title">{{ $item['title'] }}</span></a>
                <ul class="submenu collapse">
                    @foreach($item['children'] as $children)
                    <li class="{{ isActive($children['is']) }}"><a href="{{ $children['url'] }}"><i class="{{ $children['icon'] }}"></i> <span>{{ $children['title'] }}</span> </a></li>
                    @endforeach
                </ul>
            @else
                <a  href="{{ $item['url'] }}" class="{{ (Request::is([$item['is']]) ? 'main-active' : '')}} single-item d-flex align-items-center gap-2">
                    <img style="width:25px" src="{{ asset('images/hub/icons/' . $item['icon']) }}" alt=""><span class="title">{{ $item['title'] }}</span>
                </a>
            @endif
        </li>
    @endforeach

</ul>
