@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">ALL WITHDRAWALS</div>
    <div class="mi-body">
        <table class="table mi-table table-bordered" id="dataTable">
            <thead>
                <tr>
                    <tr>
                        <th>#</th>
                        <th>USER NAME</th>
                        <th>BKASH INFO</th>
                        <th>AMOUNT</th>
                        <th>MESSAGE</th>
                    </tr>
                </tr>
            </thead>
            <tbody>
                @foreach($data as $item)
                <tr>
                    <td>{{ $item->id }}</td>
                    <td>
                        <p style="white-space: nowrap"><span>Date : </span>{{ date('d M Y',strtotime($item->created_at)) }}</p>
                        <p style="white-space: nowrap"><span>Name : </span> {{ optional($item->user)->first_name }} {{ optional($item->user)->last_name }}</p>
                        <p style="white-space: nowrap"><span>Phone : </span> {{ optional($item->user)->phone }}</p>
                    </td>
                    <td>
                        <p style="white-space: nowrap"><span>Number : </span> {{ optional($item)->bkash_number }}</p>
                        <p style="white-space: nowrap"><span>Type : </span>{{ optional($item)->type }}</p>
                    </td>
                    <td>
                        <p><span>Amount : </span> {{ optional($item)->amount }}</p>
                        <p><span>Charge : </span> {{ optional($item)->charge }}</p>
                    </td>
                    <td class="d-flex align-items-center gap-2">
                        <div>
                            <p><span>Customer Message : </span> {{ optional($item)->message }}</p>
                            @if($item->status > 0)
                            <p><span>Admin Note : </span> {{ optional($item)->note }}</p>
                            @endif
                            <p><span>status : </span> {!! getWithdrawalPending($item->status) !!}</p>
                        </div>
                        @if($item->status == 0)
                        <div>
                            <button class="butn butn-sm danger" data-bs-toggle="modal" data-bs-target="#rejectRequest{{ $item->id }}"><i class="fa fa-times"></i></button>
                            <button class="butn butn-sm success" data-bs-toggle="modal" data-bs-target="#acceptRequest{{ $item->id }}"><i class="fa fa-check"></i></button>

                            <!-- Modal -->
                            <div class="modal fade" id="acceptRequest{{ $item->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                <div class="modal-content mi-card">
                                    <div class="mi-header success transparent">
                                        ACCEPT WITHDRAWAL REQUEST
                                    </div>
                                    <form action="{{ route('withdrawal.change-status',['id'=>$item->id,'status'=>ACCEPTED]) }}" method="POST">
                                        @csrf
                                        <div class="modal-body">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <th>Submission Date</th>
                                                        <td>{{ date('d M Y H:i',strtotime($item->created_at)) }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Amount</th>
                                                        <td>৳ {{ $item->amount }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Charge</th>
                                                        <td>৳ {{ $item->charge }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Subtotal</th>
                                                        <td>৳ {{ $item->amount + $item->charge }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Message</th>
                                                        <td>{{ $item->message }}</td>
                                                    </tr>

                                                    <tr>
                                                        <th>Transaction Id</th>
                                                        <td><input type="text" name="transaction_id" id="transaction_id" class="form-control"></td>
                                                    </tr>
                                                    <tr>
                                                        <th>Note</th>
                                                        <td><textarea type="text" name="note" id="note" class="form-control"></textarea></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="mi-footer d-flex gap-3" style="justify-content: flex-end">
                                            <button type="button" class="butn basic" data-bs-dismiss="modal">Close</button>
                                            <button type="submit" class="butn success">ACCEPT THIS REQUEST</button>
                                        </div>
                                    </form>
                                </div>
                                </div>
                            </div>

                            <div class="modal fade" id="rejectRequest{{ $item->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                <div class="modal-content mi-card">
                                    <div class="mi-header danger transparent">
                                        REJECT WITHDRAWAL REQUEST
                                    </div>
                                    <form action="{{ route('withdrawal.change-status',['id'=>$item->id,'status'=>REJECTED]) }}" method="POST">
                                        @csrf
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="">Note</label>
                                                <textarea type="text" name="note" id="note" class="form-control" rows="5"></textarea>
                                            </div>
                                        </div>
                                        <div class="mi-footer d-flex gap-3" style="justify-content: flex-end">
                                            <button type="button" class="butn basic" data-bs-dismiss="modal">Close</button>
                                            <button type="submit" class="butn danger">REJECT THIS REQUEST</button>
                                        </div>
                                    </form>
                                </div>
                                </div>
                            </div>

                        </div>
                        @endif
                    </td>
                </tr>

                
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection