@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">Comission wallet history</div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Customer Name</th>
                    <th>PHONE</th>
                    <th>Order Id</th>
                    <th>Amount</th>
                    <th>Ac Balance</th>
                    <th>Messages</th>
                </tr>
            </thead>
            <tbody>
                @foreach($data as $transaction)
                    <tr>
                        <td>{{ $transaction->id }}</td>
                        @if($transaction->user_id == 0)
                        <td>Admin wallet</td>
                        @else
                        <td>{{ optional($transaction->customer)->first_name.' '.optional($transaction->customer)->last_name }}</td>
                        @endif

                        <td>{{ optional($transaction->customer)->phone }}</td>
                        <td>{{ $transaction->order_id }}</td>
                        <td>{{ $transaction->amount }} ৳</td>
                        <td>{{ $transaction->current_balance }} ৳</td>
                        <td>{{ $transaction->message }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
