@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">ALL USERS</div>
    <div class="mi-body">
        <table class="table table-bordered mi-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>NAME</th>
                    <th>PHONE</th>
                    <th>OTP</th>
                    <th>WALLET</th>
                    <th>ACTION</th>
                </tr>
            </thead>

            <tbody>
                @foreach($data as $item)
                <tr>
                    <td>{{ $item->id }}</td>
                    <td>
                        <p><span>Name : </span>{{ $item->first_name. ' ' . $item->last_name }}</p>
                        <p><span>Phone : </span> {{ $item->phone }}</p>
                    </td>
                    <td>{{ $item->phone }}</td>
                    <td>{{ $item->otp }}</td>
                    <td>
                        <p><span>Cash : </span>{{ $item->cash_wallet }}</p>
                        <p><span>Comission : </span>{{ $item->comission_wallet }}</p>
                    </td>
                    <th class="mi-action-button">
                        <a href="{{ route('user.transaction',['id'=>$item->id]) }}"><button class="butn butn-sm success transparent" title="transaction history"><i class="fas fa-search-dollar"></i></button></a>
                        <a href="{{ route('user.referral',['id'=>$item->id]) }}"><button class="butn butn-sm warning transparent" title="Teams"><i class="fas fa-project-diagram"></i></button></a>
                        <a href="{{ route('order.customer.list',['user_id'=>$item->id]) }}"><button class="butn butn-sm info transparent" title="Orders"><i class="fas fa-box-open"></i></button></a>
                        @if($item->status == ACTIVE)
                        <a href="{{ route('user.change-status',['user_id'=>$item->id,'status'=>0]) }}"><button class="butn butn-sm danger transparent" title="Deactivate account"><i class="fa fa-times"></i></button></a>
                        @else
                        <a href="{{ route('user.change-status',['user_id'=>$item->id,'status'=>1]) }}"><button class="butn butn-sm success transparent" title="Activate Account"><i class="fa fa-check"></i></button></a>
                        @endif
                        <a onclick="return confirm('Are you sure to delete this account')" href="{{ route('user.delete',['user_id'=>$item->id]) }}"><button class="butn butn-sm danger transparent" title="Delete this account"><i class="fa fa-trash"></i></button></a>
                    </th>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="d-flex justify-content-end mt-3">
            {{ $data->links('vendor.pagination.bootstrap-5') }}
        </div>
    </div>
</div>
@endsection
