@extends('theme.theme')
@section('content')
<div class="row order">
    <div class="col-sm-6">
        <div class="mi-card">
            <div class="mi-header text-red">RETURN REQUEST INFORMATION</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Request Date</th>
                        <td>{{ date('d M Y H:i a', strtotime($details->created_at)) }}</td>
                    </tr>
                    <tr>
                        <th>Order Number</th>
                        <td><a href="{{ route('order.view',['id'=>$details?->orderItem?->order_id]) }}">{{ $details?->orderItem?->order?->order_number }}</a></td>
                    </tr>
                    <tr>
                        <th>Client Name</th>
                        <td>{{ $details?->user?->name }}</td>
                    </tr>
                    <tr>
                        <th>Client Phone</th>
                        <td>{{ $details?->user?->phone }}</td>
                    </tr>
                    <tr>
                        <th>Address</th>
                        <td>{{ $details?->user?->address }}</td>
                    </tr>
                    <tr>
                        <th>Client Note</th>
                        <td class="text-danger">{{ $details?->note }}</td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td class="text-text-red">{{ $details?->status_text }}</td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="mi-card">
            <div class="mi-header text-red">SHOP INFORMATION</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Shop name</th>
                        <td>{{ $details?->orderItem?->shop?->name }}</td>
                    </tr>
                    <tr>
                        <th>Shop phone</th>
                        <td>{{ $details?->orderItem?->shop?->phone }}</td>
                    </tr>
                    <tr>
                        <th>Shop Address</th>
                        <td>{{ $details?->orderItem?->shop?->shop_address }}</td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="mi-card">
            <div class="mi-header text-red">SELLER INFORMATION</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Seller name</th>
                        <td>{{ $details?->orderItem?->shop?->user?->name }}</td>
                    </tr>
                    <tr>
                        <th>Seller phone</th>
                        <td>{{ $details?->orderItem?->shop?->user?->phone }}</td>
                    </tr>
                    <tr>
                        <th>Seller Address</th>
                        <td>{{ $details?->orderItem?->shop?->user?->address }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-6">
        <div class="mi-card">
            <div class="mi-header text-red">PRODUCT INFORMATION</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Product Image</th>
                        <td>
                            <img src="{{ $details?->orderItem?->product?->thumbnailImage?->file_url }}" alt="image not found">
                        </td>
                    </tr>
                    <tr>
                        <th>Product name</th>
                        <td>{{ $details?->orderItem?->product?->name }}</td>
                    </tr>
                    <tr>
                        <th>Product Size</th>
                        <td>{{ $details?->orderItem?->size }}</td>
                    </tr>
                    <tr>
                        <th>Product Color</th>
                        <td><p class="mb-0" style="background: {{ $details?->orderItem?->color }};padding:15px 10px"></p></td>
                    </tr>
                    <tr>
                        <th>Item Sold Price</th>
                        <td>{{ $details?->orderItem?->price}}</td>
                    </tr>
                    <tr>
                        <th>Total Quantity</th>
                        <td>{{ $details?->orderItem?->qty }}</td>
                    </tr>

                    <tr>
                        <th>Total</th>
                        <td>{{ $details?->orderItem?->qty*$details?->orderItem?->price }}</td>
                    </tr>
                </table>
            </div>
        </div>
        @if($details->status == RETURN_REQUEST_PENDING || $details->status == RETURN_REQUEST_ACCEPTED)
        <form action="{{ route('return.change-status') }}" method="post">
            @csrf
            <div class="modal-content mi-card">
                <div class="mi-header warning transparent">
                    ACCEPT / REJECT RETURN REQUEST
                </div>
                <div class="mi-body">
                    <input type="hidden" name="id" value="{{ $details->id }}">
                    <div class="form-group">
                        <label for="">Status</label>
                        <select name="status" id="status" class="form-control" required>
                            <option value="">Select Status</option>
                            <option value="{{RETURN_REQUEST_ACCEPTED}}" {{ $details->status == RETURN_REQUEST_ACCEPTED?'selected':'' }}>ACCEPT RETURN REQUEST</option>
                            <option value="{{RETURN_REQUEST_REJECTED}}" {{ $details->status == RETURN_REQUEST_REJECTED?'selected':'' }}>REJECT RETURN REQUEST</option>
                            <option value="{{REFUNDED_BY_SELLER}}" {{ $details->status == REFUNDED_BY_SELLER?'selected':'' }}>REFUNDED</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Admin Note (It will be visible to the customer)</label>
                        <textarea name="admin_note" id="admin_note" class="form-control" rows="5" placeholder="Please Write A Note (It will be visible to the customer)" required>{{ $details->admin_note }}</textarea>
                    </div>
                </div>
                <div class="mi-footer text-center">
                    <button type="submit" class="butn warning">Submit</button>
                </div>
            </div>
        </form>
        @else
         <div class="mi-card">
            <div class="mi-header text-red">NOTES</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Client Note</th>
                        <td>{{ $details->note }}</td>
                    </tr>
                    <tr>
                        <th>Admin Note</th>
                        <td>{{ $details->admin_note }}</td>
                    </tr>

                </table>
            </div>
        </div>
        @endif
    </div>

</div>
@endsection
