@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">LIST OF RETURNED ITEMS</div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Customer</th>
                    <th>Shop</th>
                    <th>Product</th>
                    <th>Date</th>
                    <th>#</th>
                </tr>
            </thead>
            <tbody>
                @foreach($items as $item)
                <tr>
                    <td>{{ $item->id }}</td>
                    <td>
                        <p style="white-space: nowrap"><span>Name : </span>{{ $item?->user?->first_name. ' ' . $item?->user?->last_name }}</p>
                        <p style="white-space: nowrap"><span>Phone : </span> {{ $item?->user?->phone }}</p>
                    </td>
                    <td>
                        <p style="white-space: nowrap"><span>Name : </span>{{ $item?->orderItem?->shop?->name }}</p>
                        <p style="white-space: nowrap"><span>Phone : </span> {{ $item?->orderItem->shop?->phone }}</p>
                    </td>
                    <td>
                        <p><a target="_blank" href="{{ route('product.edit',['id'=>$item?->orderItem?->product?->id]) }}"><span>Name : </span>{{ strLimit($item?->orderItem?->product?->name , 40) }}</a></p>
                        <p>
                            @if($item?->orderItem?->size)
                            <span>Size : </span> {{ $item?->orderItem?->size }}
                            @endif
                            @if($item?->orderItem?->color)
                            <span class="ps-2">Color : </span> <span style="background-color:{{ $item?->orderItem?->color }};padding:1px 15px;margin-left:5px"></span>
                            @endif
                        </p>
                    </td>
                    <td>
                        {{ date('Y-m-d H:i:s',strtotime($item?->created_at)) }}</p>
                        <p style="white-space: nowrap"><span>Status : </span>{{ $item?->status_text }}</p>
                    </td>
                    <td class="mi-action-button">
                       <a href="{{ route('return.view',['id'=>$item->id]) }}" >
                            <button class="butn info transparent" type="button"><i class="fa fa-eye"></i></button>
                        </a>

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
