@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">
        All Ranks
        <a href="{{ route('admin.rank.create') }}">
            <button class="butn success mi-right">Add Rank</button>
        </a>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Rank Name</th>
                    <th>Type</th>
                    <th>Team A Amount</th>
                    <th>Team B Amount</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($ranks as $rank)
                    <tr>
                        <td>{{ $rank->id }}</td>
                        <td>{{ $rank->name }}</td>
                        <td>{{ getRankTypes()[$rank->type] }}</td>
                        <td>{{ $rank->team_A_amount }}</td>
                        <td>{{ $rank->team_B_amount }}</td>
                        <td>
                            <a href="{{ route('admin.rank.edit', ['id' => $rank->id]) }}">
                                <button class="butn butn-sm warning transparent">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>
                            <a
                                onclick="deleteConfirm('{{ route('admin.rank.delete', ['id' => $rank->id]) }}','Are you sure to delete')">
                                <button class="butn butn-sm danger transparent">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
