@extends('admin.theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">
        CLICK ON (+) ICON TO ADD PRODUCT
    </div>
    <div class="mi-body">
        <table class="table mi-table table-bordered" id="dataTable">
            <thead>
                <tr>
                    <th>Thumbnail</th>
                    <th>Product Name</th>
                    <th>Category</th>
                    <th>Subcategory</th>
                    <th>Brand</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($products as $product)
                <tr>
                    <td><img src="{{ $product->thumbnail_url }}" width="70px" alt=""></td>
                    <td>
                        <p><span>En:</span>{{ $product->product_name_en }}</p>
                        <p><span>Bn:</span>{{ $product->product_name_bn }}</p>
                    </td>
                    <td>
                        <p><span>En:</span>{{ optional($product->category)->category_name_en }}</p>
                        <p><span>Bn:</span>{{ optional($product->category)->category_name_bn }}</p>
                    </td>
                    <td>
                        <p><span>En:</span>{{ optional($product->subcategory)->subcategory_name_en }}</p>
                        <p><span>Bn:</span>{{ optional($product->subcategory)->subcategory_name_bn }}</p>
                    </td>
                    <td>
                        <p><span>En:</span>{{ optional($product->brand)->brand_name_en }}</p>
                        <p><span>Bn:</span>{{ optional($product->brand)->brand_name_bn }}</p>
                    </td>
                    <td class="mi-action-button">
                        <a  href="{{ route('product.create',['id'=>$product->id,'_type'=>"seller"]) }}">
                          <button class="butn danger transparent">
                            <i class="fa fa-plus"></i>
                          </button>
                        </a>
                      </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
