@extends('theme.theme') @section('content') <div class="row">
    <div class="mi-card">
      <div class="mi-header info"> LIST OF PRODUCT SUBCATEGORIES
        <a href="{{ route('product-subcategory.create') }}">
          <button class="butn success mi-right">ADD NEW SUBCATEGORY</button>
        </a>
      </div>
      <div class="mi-body">
        <table class="mi-table table table-bordered table-striped" id="dataTable">
          <thead>
            <tr>
              <th>ID</th>
              <th>CATEGORY ID</th>
              <th>SUBCATEGORY NAME (ENGLISH)</th>
              <th>SUBCATEGORY NAME (BANGLA)</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody> <?php $i=0; ?> @foreach($data as $item) <tr>
              <td>{{ ++$i }}</td>
              <td> {{ $item->category->category_name_en}} </td>
              <td> {{ $item->subcategory_name_en}} </td>
              <td> {{ $item->subcategory_name_bn}} </td>
              <td>{{ getStatuText($item->status) }}</td>
              <td class="mi-action-button">
                <a href="{{ route('product-subcategory.edit',['id'=>$item->id]) }}">
                  <button class="butn warning transparent">
                    <i class="fa fa-edit"></i>
                  </button>
                </a>
                <a onclick="return confirm('Are you sure to delete')" href="{{ route('product-subcategory.delete',['id'=>$item->id]) }}">
                  <button class="butn danger transparent">
                    <i class="fa fa-trash"></i>
                  </button>
                </a>
              </td>
            </tr> @endforeach </tbody>
        </table>
      </div>
    </div>
  </div> @endsection
