@extends('theme.theme') @section('content') <div class="row">
    <div class="col-sm-7 m-auto">
      <div class="mi-card">
        <!--start of mi-fc-card-->
        <div class="mi-header {{ $status }} ">
          <!--mi card header started-->{{ $title }} PRODUCT CATEGORY
        </div>
        <!--end of mi card header-->
        <form action="{{ route('product-category.store') }}" method="POST" enctype="multipart/form-data">
          <div class="mi-body">
            <!--mi-card body started-->
            <input name="_token" type="hidden" value="{{ csrf_token() }}"> @if(isset($data)) <input name="id" type="hidden" value="{{ $data->id }}"> @endif <div class="row">
                <div class="form-group position-relative">
                <label>CATEGORY IMAGE <b class="text-danger">*</b>
                </label> @if(isset($data)) <div class="edit-image">
                  <a href="{{asset('images'.$data->category_image)}}">
                    <img src="{{asset('images'.$data->category_image)}}" alt="">
                  </a>
                </div> @endif <input type="file" name="category_image" id="category_image" class="form-control {{ $image_class }} ">
              </div>
              <div class="form-group">
                <label for="">Category Images</label>
                <input type="file" name="images[]" multiple id="images" class="form-control">
              </div>
              <div class="form-group col-sm-">
                <label>CATEGORY NAME (English) <b class="text-danger">*</b>
                </label>
                <input type="text" placeholder="CATEGORY NAME EN" name="category_name_en" id="category_name_en" class="form-control" value="{{ isset($data)?$data->category_name_en:old('category_name_en') }}" required>
              </div>
              <div class="form-group col-sm-">
                <label>CATEGORY NAME (Bangla) <b class="text-danger">*</b>
                </label>
                <input type="text" placeholder="CATEGORY NAME BN" name="category_name_bn" id="category_name_bn" class="form-control" value="{{ isset($data)?$data->category_name_bn:old('category_name_bn') }}" required>
              </div>

              <div class="form-group col-sm-">
                <label>STATUS <b class="text-danger">*</b></label>
                <select class="form-control" id="status" name="status" required>
                    <option selected>SELECT ONE </option>
                    <option value="1" {{ isset($data) && $data->status == 1?'Selected':'' }}>Publish</option>
                    <option value="0" {{ isset($data) && $data->status == 0?'Selected':'' }}>Hide</option>
                  </select>
              </div>

              @if(isset($data))
                <div class="d-flex flex-wrap gap-2">
                    @foreach(optional($data)->images as $image)
                    <div style="width: 150px;border-radius: 10px;overflow: hidden;position:relative">
                        <img width="100%" src="{{ $image->image_url }}" alt="">
                        <a onclick="return confirm('Are you sure to delete ?')"  href="{{ route('product-category.delete-image',['id'=>$image->id]) }}">
                            <button type="button" class="butn butn-sm danger" style="position: absolute;top: 0;right: 0;"><i class="fa fa-trash"></i></button>
                        </a>
                    </div>
                    @endforeach
                </div>
              @endif
            </div>
          </div>
          <!--end of mi-card-body-->
          <div class="mi-footer">
            <!--mi-card footer started-->
            <div class="row">
              <div class="col-sm-4 m-auto">
                <button type="submit" class="butn {{ $status }} w-100"> {{ $button_name }} </button>
              </div>
            </div>
          </div>
          <!--end of mi-card-footer-->
        </form>
      </div>
      <!--end of mi-fc-card-->
    </div>
  </div> @endsection
