@extends('theme.theme')
@section('content')
<style>
    p{
        margin-bottom: 1px;
        font-family: 'Rubik';
        font-weight: 400;
    }
    span{
        color: #ccc;
    }
</style>
<div class="mi-card">
    <div class="mi-header info">
        PRODUCTS LIST
        <a href="{{ route('product-basic-info.create') }}">
            <button class="butn success mi-right">ADD NEW PRODUCT INFO</button>
        </a>
    </div>
    <div class="mi-body">
        <div class="filter mb-3">
            <form method="get">
                <div class="row">
                    <div class="form-group col-sm-3">
                        <label for="Filter by company">FILTER BY COMPANY</label>
                        <select name="company_id" id="company_id" class="form-control">
                            <option value="">Select one</option>
                            @foreach($companies as $company)
                                <option value="{{ $company->id }}" {{ $company->id==request('company_id')?'selected':'' }}>{{ $company->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">FILER BY CATEGORY</label>
                        <select name="category_id" id="category_id" class="form-control">
                            <option value="">Select one</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ $category->id==request('category_id')?'selected':'' }}>{{ $category->category_name_en }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">FILTER BY SUBCATEGORY</label>
                        <select name="subcategory_id" id="subcategory_id" class="form-control">
                            <option value="">Select one</option>
                            @foreach($subcategories as $subcategory)
                                <option value="{{ $subcategory->id }}" {{ $subcategory->id==request('subcategory_id')?'selected':'' }}>{{ $subcategory->subcategory_name_en }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">FILTER BY BRAND</label>
                        <select name="brand_id" id="brand_id" class="form-control">
                            <option value="">Select one</option>
                            @foreach($brands as $brand)
                                <option value="{{ $brand->id }}" {{ $brand->id==request('brand_id')?'selected':'' }}>{{ $brand->brand_name_en }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">FILTER BY STATUS</label>
                        <select name="status" id="status" class="form-control">
                            <option value="">Select one</option>
                            <option value="1" {{ request('status') == 1?'selected':'' }}>Active</option>
                            <option value="0" {{ request('status') == 0?'selected':'' }}>Deactive</option>
                        </select>
                    </div>
                    <div class="form-group col-sm-3 pt-4">
                        <button type="submit" class="butn warning">Filter</button>
                        <a href="{{ route('product-basic-info.list') }}"><button type="button" class="butn danger">Clear</button></a>
                    </div>
                </div>
            </form>
        </div>
        <table class="table mi-table table-bordered" id="dataTable">
            <thead>
                <tr>
                    <th>Thumbnail</th>
                    <th>Product Name</th>
                    <th>Category</th>
                    <th>Subcategory</th>
                    <th>Brand</th>
                    <th>Company Name</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($products as $product)
                <tr>
                    <td><img src="{{ $product->thumbnail_url }}" width="70px" alt=""></td>
                    <td>
                        <p><span>En:</span>{{ $product->product_name_en }}</p>
                        <p><span>Bn:</span>{{ $product->product_name_bn }}</p>
                    </td>
                    <td>
                        <p><span>En:</span>{{ optional($product->category)->category_name_en }}</p>
                        <p><span>Bn:</span>{{ optional($product->category)->category_name_bn }}</p>
                    </td>
                    <td>
                        <p><span>En:</span>{{ optional($product->subcategory)->subcategory_name_en }}</p>
                        <p><span>Bn:</span>{{ optional($product->subcategory)->subcategory_name_bn }}</p>
                    </td>
                    <td>
                        <p><span>En:</span>{{ optional($product->brand)->brand_name_en }}</p>
                        <p><span>Bn:</span>{{ optional($product->brand)->brand_name_bn }}</p>
                    </td>
                    <td>
                        {{ optional($product->company)->name }}
                    </td>
                    <td class="mi-action-button">
                        <a href="{{ route('product-basic-info.edit',['id'=>$product->id]) }}">
                          <button class="butn warning transparent">
                            <i class="fa fa-edit"></i>
                          </button>
                        </a>
                        <a onclick="return confirm('Are you sure to delete')" href="{{ route('product-basic-info.delete',['id'=>$product->id]) }}">
                          <button class="butn danger transparent">
                            <i class="fa fa-trash"></i>
                          </button>
                        </a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
