@extends('theme.theme')
@section('content')
    <style>
        th{
            padding: 7px !important
        }
        th,td{
            font-size: 13px !important;
        }
        .mi-header{
            padding: .5rem 1rem !important
        }
        table{
            margin-bottom: 0px !important;
        }
    </style>
    <div class="row order">
        <div class="col-sm-12">
            <div class="header">
                <div>
                    <p class="order_number text-red d-flex">{{ $order->order_number }} <span class="text-gray ps-2" style="font-weight: 400">  - {{ getPaymentMethod($order->payment_method) }}</span></p>
                    <p class="text-gray">Order Time : {{ date('d M Y H:i',strtotime($order->created_at)) }}</p>
                </div>
                <button class="butn butn-sm danger" data-bs-toggle="modal" data-bs-target="#howtoprep">How to prepare order</button>
            </div>
        </div>
        <div class="col-sm-12">
            <div class="order-card">
                <div class="header">
                    <h4>Order Information</h4>
                </div>
                <div class="info-text">
                    <div>
                        <p class="text-red label">Customer Name</p>
                        <p class="text-gray">{{ optional($order->user)->first_name }} {{ optional($order->user)->last_name }}</p>
                    </div>
                    <div>
                        <p class="text-red label">Order Number</p>
                        <p class="text-gray">{{ optional($order)->order_number }}</p>
                    </div>
                    <div class="phone">
                        <i class="fa fa-phone-alt text-red"></i>
                        <p>To reach the customer , call {{ optional($order->user)->phone }}</p>
                    </div>
                    <div>
                        <p class="text-red label">Delivery location</p>
                        <p class="text-gray">{{ optional($order->user)->address }}</p>
                    </div>
                    <div>
                        <p class="text-red label">Payment Status</p>
                        <p class="text-gray">@if($order->paid_from_wallet > 0 ) Paid From Wallet - ৳{{ $order->paid_from_wallet }} | @endif Due - ৳{{ $order->due }}</p>
                    </div>
                </div>
            </div>
            <div class="order-card">
                <div class="header">
                    <h4>Delivery Hub Information</h4>
                </div>
                <div class="info-text">
                    <div>
                        <p class="text-red label">Hub Name</p>
                        <p class="text-gray">{{ optional($order->hub)->business_title }}</p>
                    </div>
                    <div>
                        <p class="text-red label">Propiter Name</p>
                        <p class="text-gray">{{ optional($order->hub)->propiter_name }}</p>
                    </div>
                    <div class="phone">
                        <i class="fa fa-phone-alt text-red"></i>
                        <p>To reach the Propiter , call {{ optional($order->hub)->phone }}</p>
                    </div>
                    <div>
                        <p class="text-red label">Hub location</p>
                        <p class="text-gray">
                            @if(optional($order->hub)->_businessDivision)
                                {{ optional($order->hub)->_businessDivision->name.',' }}
                            @endif

                            @if(optional($order->hub)->_businessDistrict)
                                {{ optional($order->hub)->_businessDistrict->name.',' }}
                            @endif

                            {{ optional($order->hub)->business_address }}
                        </p>
                    </div>
                </div>
            </div>

            <div class="order-card" style="padding-top: 45px;">
                <div class="wrapper orderStatus">
                    <?php $statusTime = statusTimes($order->id) ?>
                    <ul class="status-line">
                      <li class="{{ $statusTime->confirmed_time?'active':'' }}"><i class="{{ $statusTime->confirmed_time?'done':'' }} flaticon-shopping-bag"></i><p class="text-gray">Order Confirmed</p><p>{{ $statusTime->confirmed_time?date('d-m-Y H:i',strtotime($statusTime->confirmed_time)):'' }}</p></li>
                      <li class="{{ $statusTime->accepted_time?'active':'' }}"><i class="{{ $statusTime->accepted_time?'done':'' }} flaticon-order"></i><p class="text-gray">Order Accepted</p><p>{{ $statusTime->accepted_time?date('d-m-Y H:i',strtotime($statusTime->accepted_time)):'' }}</p></li>
                      <li class="{{ $statusTime->reached_time?'active':'' }}"><i class="{{ $statusTime->reached_time?'done':'' }} flaticon-product-1"></i><p class="text-gray">Reached in delivery hub</p><p>{{ $statusTime->reached_time?date('d-m-Y H:i',strtotime($statusTime->reached_time)):'' }}</p></li>
                      <li class="{{ $statusTime->ready_for_delivery_time?'active':'' }}"><i class="{{ $statusTime->ready_for_delivery_time?'done':'' }} flaticon-booking"></i><p class="text-gray">Ready for delivery</p><p>{{ $statusTime->ready_for_delivery_time?date('d-m-Y H:i',strtotime($statusTime->ready_for_delivery_time)):'' }}</p></li>
                      <li class="{{ $statusTime->out_for_delivery_time?'active':'' }}"><i class="{{ $statusTime->out_for_delivery_time?'done':'' }} flaticon-fast-delivery"></i><p class="text-gray">Out for delivery</p><p>{{ $statusTime->out_for_delivery_time?date('d-m-Y H:i',strtotime($statusTime->out_for_delivery_time)):'' }}</p></li>
                      <li class="{{ $statusTime->delivered_time?'active':'' }}"><i class="{{ $statusTime->delivered_time?'done':'' }}  flaticon-delivered-1"></i><p class="text-gray">Delivered</p><p>{{ $statusTime->delivered_time?date('d-m-Y H:i',strtotime($statusTime->delivered_time)):'' }}</p></li>
                    </ul>
                  </div>
            </div>
        </div>
        <div class="col-sm-12">
            <div class="mi-card">
                <div class="mi-header text-red">
                    Order Items
                </div>
                <div class="mi-body">
                    <table class="table mi-table table-bordered">
                        <thead>
                            <tr>
                                <th>Image</th>
                                <th>Item Name</th>
                                <th>Shop Name</th>
                                <th>Qty</th>
                                <th>Price</th>
                                <th>Hub</th>
                                <th>Subtotal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($order->orderItems as $orderItems)

                                <tr>
                                    <td>
                                        <img src="{{ optional($orderItems->product)->thumbnailImage?->file_url }}" width="60px" alt="">
                                    </td>
                                    <td>
                                        <p><span>En: </span>{{ optional($orderItems->product)->product_name_en }}</p>
                                        <p><span>En: </span>{{ optional($orderItems->product)->product_name_bn }}</p>
                                    </td>
                                    <td>
                                        <p><span>En: </span>{{ optional($orderItems->shop)->shop_name_en }}</p>
                                        <p><span>En: </span>{{ optional($orderItems->shop)->shop_name_bn }}</p>
                                    </td>
                                    <td class="center">
                                        {{ optional($orderItems)->qty }}
                                    </td>
                                    <td>
                                        <p><span>Price: </span>৳{{ optional($orderItems)->price }}</p>
                                        <p><span>Discount: </span>৳{{ optional($orderItems)->discount }}</p>
                                    </td>
                                    <td>
                                        <p><span>Hub: </span>{{ optional($orderItems->hub)->hub_name }}</p>
                                        <p><span>Status: </span>{{ getOrderItemStatus($orderItems->status) }}</p>
                                    </td>
                                    <td class="center">
                                        ৳{{ optional($orderItems)->price }}
                                    </td>
                                    @if($orderItems->status < 2)
                                    <td>
                                        <button type="button" class="butn butn-sm success transparent" data-bs-toggle="modal" data-bs-target="#acceptModal{{ $orderItems->id }}"><i class="fa fa-check"></i></button>
                                          <!-- Modal -->
                                        <div class="modal fade" id="acceptModal{{ $orderItems->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-content mi-card">
                                                <div class="mi-header info">RECIVE PRODUCT IN HUB</div>
                                                <form action="{{ route('order.item-status-change',['order_item_id'=>$orderItems->id]) }}" method="POST">
                                                    @csrf
                                                    <div class="mi-body">
                                                        <div class="form-group">
                                                            <label for="">PLEASE SELECT ONE</label>
                                                            <div class="form-check">
                                                                    @if($orderItems->status == 1)
                                                                    <input class="form-check-input" type="radio" name="status" value="2" id="accept{{$orderItems->id}}" checked required>
                                                                    <label class="form-check-label" for="accept{{$orderItems->id}}">
                                                                    ACCEPT (PRODUCT REACHED IN CUSTOMER DELIVERY HUB)
                                                                    </label>
                                                                    @elseif($orderItems->status == 0)
                                                                    <input class="form-check-input" type="radio" name="status" value="1" id="accept{{$orderItems->id}}" checked required>
                                                                    <label class="form-check-label" for="accept{{$orderItems->id}}">
                                                                    ACCEPT (PRODUCT REACHED AT SELLER NEAREST DELIVERY HUB)
                                                                    </label>
                                                                @endif
                                                              </div>

                                                              <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="status" value="3" id="reject{{$orderItems->id}}2" required>
                                                                <label class="form-check-label" for="reject{{$orderItems->id}}2">
                                                                  REJECT (FOR SOME RESON PRODUCT CANT BE DELIVERED)
                                                                </label>
                                                            </div>
                                                        </div>

                                                        <div class="form-group">
                                                            <label for="">WRITE A NOTE <b class="text-danger">*</b></label>
                                                            <textarea name="note" id="note" class="form-control" rows="3" required></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="mi-footer text-center">
                                                        <button class="butn success">SAVE</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                    @endif
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <?php $itemsTotal = getItemsTotal($order->orderItems) ?>
                            <tr>
                                <th colspan="6">Items Total</th>
                                <td>৳ <?= $itemsTotal ?></td>
                            </tr>
                            <tr>
                                <th colspan="6">Tax</th>
                                <td>৳ {{ $order->tax }}</td>
                            </tr>
                            <tr>
                                <th colspan="6">Delivery Charge</th>
                                <td>৳ {{ $order->delivery_charge }}</td>
                            </tr>
                            <tr>
                                <th colspan="6">Coupon Dicount</th>
                                <td>- ৳ {{ $order->discount_amount }}</td>
                            </tr>
                            <tr>
                                <th colspan="6">Total</td>
                                <td>৳ {{ ($itemsTotal+$order->tax+$order->delivery_charge)-$order->discount_amount }}</td>
                            </tr>
                            <tr>
                                <th colspan="6">Paid from wallet</td>
                                <td style="color: green">৳ {{ $order->paid_from_wallet }}</td>
                            </tr>

                            <tr>
                                <th colspan="6">Due</td>
                                <td style="color: red">৳ {{ (($itemsTotal+$order->tax+$order->delivery_charge)-$order->discount_amount)-$order->paid_from_wallet }}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="mi-card">
                <div class="mi-header text-red">Order Status History</div>
               <div class="mi-body">
                    @foreach($order->orderStatusHistory as $history)
                    <div class="status-card">
                        <div style="width: 120px">
                            <p class="text-red">{{ getStatus($history->status_id) }}</p>
                        </div>
                        <div>
                            <p><span class="label">Date:</span> {{ date('d M Y H:i:A',strtotime($history->created_at)) }}</p>
                            <p><span class="label">Note:</span> {{ $history->note }}</p>
                        </div>
                    </div>
                    @endforeach
               </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="mi-card">
                <div class="mi-header text-red">Order Item History</div>
               <div class="mi-body">
                    @foreach($order->orderItemHistory as $itemHistory)
                    <div class="status-card">
                        <div>
                            <p><span class="label">Date:</span> {{ date('d M Y H:i',strtotime($itemHistory->created_at)) }}</p>
                            <p class="text-red"> {{ getOrderItemStatus($itemHistory->status) }}</p>
                        </div>
                        <div>
                            <p>Product name : {{ optional($itemHistory->item)->product_name_en }}</p>
                            <p><span class="label">Note:</span> {{ $itemHistory->note }}</p>
                        </div>
                    </div>
                    @endforeach
               </div>
            </div>
        </div>
        <div class="col-sm-12 floa-right">
            <div class="buttons">
                @if($order->status < ORDER_DELIVERED)
                <a ><button class="butn danger">CANCEL</button></a>
                @endif
                @if($order->status == ORDER_PENDING)
                <a onclick="return confirmBox({'status':'success','title':'Are you sure to accept this order ? ','body':'If you accept this order than this order will go to the seller panel & delivery hub'},event)" href="{{ route('order.status.change',['order_id'=>$order->id,'status'=>ORDER_ACCEPTED]) }}" ><button class="butn success"  >ACCEPT ORDER</button></a>
                @elseif($order->status == ORDER_ACCEPTED)
                <a onclick="return confirmBox({'status':'success','title':'Are you sure ? ','body':'Are you sure that all items reached in delivery hub please verify'},event)" href="{{ route('order.status.change',['order_id'=>$order->id,'status'=>ORDER_REACHED_IN_DELIVERY_HUB]) }}" ><button class="butn warning"  >ITEMS REACHED IN DELIVERY HUB</button></a>
                @elseif($order->status == ORDER_REACHED_IN_DELIVERY_HUB)
                <a onclick="return confirmBox({'status':'success','title':'Are you sure ? ','body':'Are you sure order is ready for delivery'},event)" href="{{ route('order.status.change',['order_id'=>$order->id,'status'=>ITEMS_REACHED_IN_MAIN_HUB]) }}" ><button class="butn info"  >ORDER IS READY FOR DELIVERY</button></a>
                @elseif($order->status == ITEMS_REACHED_IN_MAIN_HUB)
                <a onclick="return confirmBox({'status':'success','title':'Are you sure? ','body':'Please be sure order is out for delivery or not'},event)" href="{{ route('order.status.change',['order_id'=>$order->id,'status'=>ITEMS_REACHED_IN_CUSTOMER_HUB]) }}" ><button class="butn warning"  >ORDER IS OUT FOR DELIVERY</button></a>
                @elseif($order->status == ITEMS_REACHED_IN_CUSTOMER_HUB)
                <a onclick="return confirmBox({'status':'success','title':'Are you sure? ','body':'Please be sure order is delivered or not'},event)" href="{{ route('order.status.change',['order_id'=>$order->id,'status'=>ORDER_DELIVERED]) }}" ><button class="butn success"  >ORDER DELIVERED</button></a>
                @endif

            </div>
        </div>
    </div>


    <!-- Modal -->
<div class="modal fade" id="howtoprep" tabindex="-1" aria-labelledby="howtoprepLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content mi-card">
        <div class="mi-header info">
          <h5 class="modal-title" id="howtoprepLabel">How To Prepare Order</h5>
        </div>
        <div class="mi-body">
          <img src="https://partner.movo.delivery/assets/order-prep-tips.webp" width="100%" alt="">
        </div>
        <div class="mi-footer text-center">
          <button type="button" class="butn danger" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>


@endsection
