@extends('theme.theme') @section('content') <div class="row">
    <div class="mi-card">
      <div class="mi-header info"> LIST OF OFFERS
        <a href="{{ route('offer.create') }}">
          <button class="butn success mi-right">ADD NEW OFFER</button>
        </a>
      </div>
      <div class="mi-body">
        <table class="mi-table table table-bordered table-striped">
          <thead>
            <tr>
              <th>ID</th>
              <th>OFFER NAME (ENGLISH)</th>
              <th>OFFER NAME (BANGLA)</th>
              <th>START DATE</th>
              <th>END DATE</th>
              <th>AMOUNT</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody> <?php $i = 0; ?> @foreach($data as $item) <tr>
              <td>{{ ++$i }}</td>
              <td> {{ $item->offer_name_en}} </td>
              <td> {{ $item->offer_name_bn}} </td>
              <td> {{ date('d M Y',strtotime($item->start_date)) }} </td>
              <td> {{ date('d M Y',strtotime($item->end_date)) }} </td>
              <td> {{ $item->amount}} </td>
              <td class="mi-action-button">
                <a href="{{ route('offer.edit',['id'=>$item->id]) }}">
                  <button class="butn warning transparent">
                    <i class="fa fa-edit"></i>
                  </button>
                </a>
                <a onclick="return confirm('Are you sure to delete')" href="{{ route('offer.delete',['id'=>$item->id]) }}">
                  <button class="butn danger transparent">
                    <i class="fa fa-trash"></i>
                  </button>
                </a>
              </td>
            </tr> @endforeach </tbody>
        </table>
      </div>
      <div class="mi-footer">
        <div class="float-right"></div>
      </div>
    </div>
  </div> @endsection
