@extends('theme.theme')
@section('content')
<style>
  p{
      margin-bottom: 1px;
      font-family: 'Rubik';
      font-weight: 400;
  }
  span{
      color: #ccc;
  }
</style>
<div class="row">

    <div class="mi-card">
      <div class="mi-header info"> LIST OF PRODUCTS
        <a href="{{ route('admin.mystore.product.create') }}">
          <button class="butn success mi-right">ADD NEW PRODUCT</button>
        </a>
      </div>
      <div class="mi-body">
        <table class="mi-table table table-bordered table-striped" id="dataTable">
          <thead>
            <tr>
              <th>ID</th>
              <th>IMAGE</th>
              <th>PRODUCT NAME</th>
              <th>CATEGORY NAME</th>
              <th>SUBCATEGORY NAME</th>
              <th>Sale Price</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            @foreach($products as $product) <tr>
                  <td>{{ $product->id }}</td>
                  <td><img width="70px" src="{{ $product?->basicInfo?->thumbnail_url }}" alt=""></td>
                  <td>
                    <p>{{ $product?->basicInfo?->name }}</p>
                  </td>
                  <td>
                    <p>{{ $product?->basicInfo?->category->name }}</p>
                  </td>
                  <td>
                    <p>{{ $product?->basicInfo?->subcategory?->name }}</p>
                  </td>

                  <td>
                    {{ $product->sale_price }}
                  </td>

                  <td>
                    <a href="{{ route('admin.mystore.product.edit', ['id' => $product->id]) }}">
                      <button class="butn butn-sm warning transparent">
                        <i class="fa fa-edit"></i>
                      </button>
                    </a>
                    <a onclick="deleteConfirm('{{ route('admin.mystore.product.delete', ['id' => $product->id]) }}')">
                      <button class="butn butn-sm danger transparent">
                        <i class="fa fa-trash"></i>
                      </button>
                    </a>
                  </td>
                </tr>
            @endforeach
            </tbody>
        </table>
      </div>
    </div>
  </div> @endsection
