@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">ALL FUND REQUESTS</div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($requests as $request)
                    <tr>
                        <td>{{ $request->id }}</td>
                        <td>{{ $request->hub?->name }}</td>
                        <td>{{ $request->hub?->email }}</td>
                        <td>{{ $request->hub?->phone }}</td>
                        <td>৳ {{ number_format($request->amount, 2) }}</td>
                        <td>{{ $request->status_text }}</td>
                        <td>
                            <a data-bs-toggle="modal" data-bs-target="#detailsModal">
                                <button class="butn butn-sm info transparent"><i class="fa fa-eye"></i></button>
                            </a>
                            @include('admin.my-store.fund.details-modal')
                            @if($request->status == FUND_REQUEST_PENDING)
                                <a
                                    onclick="_confirm('{{ route('admin.mystore.fund.accept-request', ['id' => $request->id]) }}','Are you sure to accept this request')">
                                    <button class="butn butn-sm success transparent"><i class="fa fa-check"></i></button>
                                </a>
                                <a onclick="rejectRequest({{ $request->id }})">
                                    <button class="butn butn-sm danger transparent"><i class="fa fa-times"></i></button>
                                </a>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@include('admin.my-store.fund.reject-modal');
<script>
    function rejectRequest(id){
        $('#request_id').val(id);
        $('#rejectModal').modal('show');
    }
</script>
@endsection

