@extends('theme.theme')
@section('content')
<div class="row">
    <div class="col-sm-8 m-auto">
        <div class="mi-card">
            <div class="mi-header success">{{ $data?'Edit Group Products':'Add Product Groups' }}</div>
            <form action="{{ route('group-product.store',['id'=>$data?->id]) }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="mi-body">
                    <div class="row">
                        <div class="col-sm-6 form-group">
                            <label for="">Name (English) <b class="text-danger">*</b></label>
                            <input type="text" name="name_en" id="name_en" class="form-control" value="{{ $data?->name_en }}" required>
                        </div>
                        <div class="col-sm-6 form-group">
                            <label for="">Name (Bangla)</label>
                            <input type="text" name="name_bn" id="name_bn" class="form-control" value="{{ $data?->name_bn }}">
                        </div>
                        <div class="form-group position-relative col-sm-6">
                            <label>Icon <b class="text-danger">*</b>
                            </label> @if(isset($data)) <div class="edit-image" style="width:100px !important">
                            <a href="{{$data->icon_url}}">
                                <img src="{{$data->icon_url}}" alt="">
                            </a>
                            </div> @endif <input type="file" name="icon" id="icon" class="form-control {{ isset($data)?'edit-input':'' }} ">
                        </div>
                        <div class="col-sm-6 form-group m-auto">
                            <label for="">Status</label>
                            <select name="status" id="status" class="form-control">
                                <option value="1" {{ $data?->id==1?'selected':'' }}>Active</option>
                                <option value="0" {{ $data?->id==0?'selected':'' }}>Inactive</option>
                            </select>
                        </div>
                        <div class="col-sm-12 form-group">
                            <label for="">Select Products</label>
                            <select name="product_ids[]" multiple id="product_ids" class="form-control" placeholder="Select Products">
                                @foreach($products as $product)
                                    <option value="{{ $product->id }}" {{ in_array($product->id,$selectedProducts)?'selected':'' }}>{{ $product->product_name_en }} - ({{$product?->shop?->name}})</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="mi-footer d-flex justify-content-end">
                    <button type="submit" class="butn success">{{ $data?'Update':'Create' }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
