@extends('theme.theme')
@section('content')
    <div class="row">
        <div class="col-sm-8 m-auto">
            <div class="mi-card">
                <!--start of mi-fc-card-->
                <div class="mi-header {{ $status }} ">
                    <!--mi card header started-->{{ $title }} BANNER
                </div>
                <!--end of mi card header-->
                <form action="{{ route('banner.store') }}" method="POST" enctype="multipart/form-data">
                    <div class="mi-body" id="app">
                        <!--mi-card body started-->
                        <input name="_token" type="hidden" value="{{ csrf_token() }}">
                        <input name="id" type="hidden" value="{{ $data?->id }}">
                        <div class="row">
                            <div class="form-group position-relative">
                                <label>BANNER IMAGE <b class="text-danger">@if($data?->id>0)(WIDTH:800 & HEIGHT:300)@endif*</b></label>
                                @if ($data?->banner_image)
                                    <div class="edit-image">
                                        <a href="{{ asset('images' . $data?->banner_image) }}">
                                            <img src="{{ asset('images' . $data?->banner_image) }}" alt="">
                                        </a>
                                    </div>
                                @endif
                                <input type="file" name="banner_image" id="banner_image"
                                    class="form-control {{ $image_class }} ">
                            </div>
                            <div class="form-group">
                                <label>TYPE <b class="text-danger">*</b>
                                </label>
                                <select class="form-control" id="type" name="type" required>
                                    <option value="1" {{ $data?->type == 1 ? 'Selected' : '' }}>Category</option>
                                    <option value="2" {{ $data?->type == 2 ? 'Selected' : '' }}>Shop</option>
                                    <option value="3" {{ $data?->type == 3 ? 'Selected' : '' }}>Link</option>
                                </select>
                            </div>
                            <div v-if="banner_type == 1">
                                <div class="form-group">
                                    <label>Category <b class="text-danger">*</b></label>
                                    <select name="link" id="link" class="form-control" required>
                                        <option value="">SELECT CATEGORY</option>
                                        @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{  $category->id == $data?->link?'selected':'' }}>{{ $category->category_name_en }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div v-if="banner_type == 2">
                                <div class="form-group">
                                    <label>Shop <b class="text-danger">*</b></label>
                                    <select name="link" id="link" class="form-control" required>
                                        <option value="">SELECT SHOP</option>
                                        @foreach($shops as $shop)
                                        <option value="{{ $shop->id }}" {{  $shop->id == $data?->link?'selected':'' }}>{{ $shop->shop_name_en }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div v-if="banner_type == 3">
                                <div class="form-group">
                                    <label>Link <b class="text-danger">*</b></label>
                                    <input type="text" placeholder="LINK" name="link" id="link" class="form-control"
                                        value="{{ old('link') ?? $data?->link }}" required>
                                </div>
                            </div>

                            <div class="row ps-0 pe-0">
                                <div class="form-group col-sm-6">
                                    <label>PUBLISH DATE </label>
                                    <input type="datetime-local" name="publish_at" id="publish_at" class="form-control"
                                        value="{{ old('publish_at') ?? $data?->publish_at }}">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>UNPUBLISH DATE </label>
                                    <input type="datetime-local" name="unpublish_at" id="unpublish_at" class="form-control"
                                        value="{{ old('unpublish_at') ?? $data?->unpublish_at }}">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>STATUS <b class="text-danger">*</b>
                                </label>
                                <select class="form-control" id="status" name="status" required>
                                    <option selected>SELECT ONE </option>
                                    <option value="1" {{ $data?->status == 1 ? 'Selected' : '' }}>
                                        Publish
                                    </option>
                                    <option value="0" {{ $data?->status == 0 ? 'Selected' : '' }}>Hide
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <!--end of mi-card-body-->
                    <div class="mi-footer">
                        <!--mi-card footer started-->
                        <div class="row">
                            <div class="col-sm-4 m-auto">
                                <button type="submit" class="butn {{ $status }} w-100"> {{ $button_name }}
                                </button>
                            </div>
                        </div>
                    </div>
                    <!--end of mi-card-footer-->
                </form>
            </div>
            <!--end of mi-fc-card-->
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/vue@2"></script>
    <script>
        var app = new Vue({
            el: '#app',
            data: {
                banner_type:1
            },
            mounted(){
                const type = @Json($data?->type);
                if(type){
                    this.banner_type = type;
                }
                $('#type').on('change', this.setBannerType);
            },
            methods: {
                setBannerType(){
                    const type = $('#type').val();
                    this.banner_type = type;
                    if(type == 1 || type == 2){
                        setTimeout(() => {
                            $('#link').select2();
                        }, 300);
                    }
                }
            },
        })
    </script>
@endsection
