@extends('admin.admin-wallet.app')
@section('main-content')
    <div class="mi-card">
        <div class="mi-body">
            <table class="table table-bordered mi-table" >
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Order Number</th>
                        <th>Message</th>
                        <th>Current Balance</th>
                        <th>Recived From</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($histories as $history)
                        <tr>
                            <td>{{ Carbon\Carbon::parse($history->created_at)->format('d M Y') }}</td>
                            <td>{{ formatAmount($history->amount) }}</td>
                            <td>{{ $history->order?->order_number ?? 'N/A' }}</td>
                            <td>{{ $history->message ?? 'N/A' }}</td>
                            <td>{{ formatAmount($history->current_balance) }}</td>
                            <td>{{ $history->receivedForm?->name ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="d-flex justify-content-end mt-3">
                {{ $histories->links('vendor.pagination.bootstrap-5') }}
            </div>
        </div>
    </div>
@endsection
