import './bootstrap';
import { createApp } from 'vue';
import ToastPlugin from 'vue-toast-notification';
import 'vue-toast-notification/dist/theme-bootstrap.css';
import ImageComponent from './components/Image.vue'
import axios from 'axios';
import WithdrawalForm from './components/WithdrawalForm.vue';

const app = createApp({
    components:{
        ImageComponent,
        WithdrawalForm
    }
});
app.config.globalProperties.$axios = axios;
app.use(ToastPlugin,{position: 'top-right'});

app.mixin({
    methods: {
        changeUserStatus(id) {
            axios.get(`/admin/shareholder/change-status/${id}`).then((res)=>{
                this.$toast.success(res?.data?.message);
            }).catch((error)=>{
                console.log(error);
                $('#checkbox'+id).prop('checked', false);
            })
        }
    }
});


app.mount('#app')
