<?php

namespace App\Services;

use App\Models\AdminWallet;
use App\Models\ComissionWalletHistory;
use App\Models\FlashWallet;
use App\Models\FlashWalletHistory;

class WalletService
{
    public static function getTotal($type){
        $currentBalance = FlashWallet::first()->value(flashWalletTypes()[$type]);
        $totalBalance  = FlashWalletHistory::where('type',$type)->where('amount','>',0)->sum('amount');
        return  collect([
            'current_balance'=>$currentBalance,
            'total_income_amount'=>$totalBalance,
            'total_withdrawal_amount'=>$totalBalance-$currentBalance,
        ]);
    }


    public static function getAdminWalletTotal($type){
        $fieldName = flashWalletTypes()[$type];
        $currentBalance = AdminWallet::first()->value($fieldName);
        $totalBalance = ComissionWalletHistory::where('type',$type)->where('transaction_type',1)->sum('amount');
        $totalWithdrawalBalance  = $totalBalance-$currentBalance;
        return  collect([
            'current_balance'=>$currentBalance,
            'total_income_amount'=>$totalBalance,
            'total_withdrawal_amount'=>$totalWithdrawalBalance,
        ]);
    }

    public function deductFromUserComission(object $user,float $amount,int $transactionType,string $type,string $message,int $orderId=null){
        $user->decrement('comission_wallet',$amount);
        ComissionWalletHistory::create([
            'user_id'=>$user->id,
            'amount'=>-$amount,
            'transaction_type'=>$transactionType,
            'type'=>$type,
            'message'=>$message,
            'current_balance'=>$user->comission_wallet,
            'order_id'=>$orderId,
        ]);

        return true;
    }

    public function sendComissionToFlashWallet(int|null $orderId,float $commission,string $message,string $type,int $userId=null){
        if(!$commission)
            return true;

        $fieldName = flashWalletTypes()[$type];
        $adminWallet = FlashWallet::where('id',1)->first();
        $adminWallet->increment($fieldName,$commission);

        FlashWalletHistory::create([
            'order_id'=>$orderId,
            'user_id'=>$userId,
            'amount'=>$commission,
            'type'=>$type,
            'message'=>$message,
            'current_balance'=>$adminWallet[$fieldName]
        ]);
        return true;
    }
}
