<?php

namespace App\Services;

use App\Models\Admin;
use App\Models\AdminWallet;
use App\Models\Comission;
use App\Models\ComissionWalletHistory;
use App\Models\DeliveryHub;
use App\Models\FlashWallet;
use App\Models\FlashWalletHistory;
use App\Models\FundHistory;
use App\Models\LeadershipLevel;
use App\Models\Notification;
use App\Models\Order;
use App\Models\OrderItems;
use App\Models\OrderStatusHistory;
use App\Models\User;
use Carbon\Carbon;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Illuminate\Support\Facades\Log;

use function PHPSTORM_META\type;

class OrderService
{
    public $adminWallet=[
        'SPONSOR'=>'sponsor_commission',
        'LEADERSHIP'=>'leadership_commission',
        'TEAM'=>'team_commission',
        'SPONSOR_ROYALTI'=>'sponsor_royalti_commission',
        'UPLINE_POLL'=>'upline_poll_commission',
        'DIAMOND_POLL'=>'diamond_poll_commission',
        'LEADERSHIP_UPGRADE'=>'lpb_commission',
    ];
    public function shareComission(object $order){
        $this->distributeReferelBonus($order);
        $this->distributeLeadershipnBonus($order);
        $order->update(['is_comission_shared'=>1]);
        return true;
    }

    public function setRefundTime(int $orderId){
        OrderItems::with('product')->where('order_id',$orderId)->get()->map(function($orderItem){
            $refundEndTime = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . '+'.$orderItem?->product?->refund_time.' days'));
            $orderItem->update(['refund_end_time'=>$refundEndTime]);
            $orderItem->product?->increment('total_sold',$orderItem->qty);
        });
        return true;
    }

    public function writeStatusLog(int $orderId, int $status, object $auth,){
        $statusData =  [
            'order_id'=>$orderId,
            'status_id'=>$status,
            'note'=>'Order status has been changed by '.$auth->name
        ];
        OrderStatusHistory::updateOrCreate(['order_id'=>$orderId,'status_id'=>$status],$statusData);
        return true;
    }

    public function setUserPackage(object $order){
        $packageId = $order->orderItems?->first()?->product?->package_id;
        if(!$packageId) return false;
        $order->update([
            'package_id'=>$packageId,
            'package_expiry_date'=>Carbon::now()->addMonths(1)
        ]);
        return true;
    }

    public function chargeFromFund(object $order){
        $order->hub->decrement('fund_balance',$order->order_total);
        FundHistory::create([
            'order_id'=>$order->id,
            'hub_id'=>$order->hub->id,
            'amount'=>-$order->order_total,
            'type'=>'FUND',
            'message'=>$order->order_total.taka().' has been debited'
        ]);
        return true;
    }

    public function transferToCODWallet(object $order){
        $order->hub->increment('cod_balance',$order->order_total);
        FundHistory::create([
            'order_id'=>$order->id,
            'hub_id'=>$order->hub->id,
            'amount'=>$order->order_total,
            'type'=>'COD',
            'message'=>$order->order_total.taka().' has been credited'
        ]);
        return true;
    }

    public function transferDeliveryComission(object $order){
        $order->hub->increment('commission_balance',$order->delivery_charge);
        ComissionWalletHistory::create([
            'hub_id'=>$order->hub->id,
            'order_id'=>$order->id,
            'amount'=>$order->delivery_charge,
            'transaction_type'=>DELIVERY_COMISSION,
            'message'=>'You recived delivery commission '.$order->delivery_charge.taka().' from #'.$order->number
        ]);
    }


    public function sendNotification(object $order){
        $orderStatus = [
            ORDER_ACCEPTED => "Welcome to ezone . We accpted your order(#".$order->order_number."). We will notify you in every steps of your order process",
            ITEMS_REACHED_IN_MAIN_HUB => "Your order(#".$order->order_number.") is ready for delivery, out driver will reach the items to you very soon",
            ITEMS_REACHED_IN_CUSTOMER_HUB => "Your order(#".$order->order_number.") is out for delivery . our handled your items to our delivery man , he will reach to you very soon",
            ORDER_REACHED_IN_DELIVERY_HUB => "Your order(#".$order->order_number.") items reached in our delivery hub . very soon we will deliver it to you",
            ORDER_DELIVERED => "We deliverd your order(#".$order->order_number.") . please check the order items , if you found broken/unordered/unexpected item please contact with us ASAP",
        ];
        $message = $orderStatus[$order->status].' https://admin.robiulawal.xyz/';
        $title = getStatus($order->status);
        Notification::addNotification($title,$message,$order->user_id);
        Notification::sendSms($message,$order->phone);
        return true;
    }



    public function sendCommissionToUser(object $user,int $orderId,float $commission,string $message,string $type){
        if(!$commission)
            return true;

        if($user->id  == 1){
            $fieldName = $this->adminWallet[$type];
            AdminWallet::increment($fieldName,$commission);
        }

        Notification::sendNotification('Received Spot Comission',$message,$user->id);
        $user->increment('comission_wallet',$commission);
        $currentBalance = $user->comission_wallet;

        ComissionWalletHistory::create([
            'user_id'=>$user->id,
            'order_id'=>$orderId,
            'amount'=>$commission,
            'transaction_type'=>COMMISSION,
            'type'=>$type,
            'message'=>$message,
            'current_balance'=>$currentBalance
        ]);
        return true;
    }


    public function distributeReferelBonus(object $order){
        if(comissionStatus()){
            $walletservice = new WalletService();
            $maxLevel = maxComissionLevel();
            $spotComission = (float)$order->total_spot_comission;
            $teamComission = (float)$order->total_team_comission;
            $sponsorRoyaltiComission = (float)$order->total_sponsor_royalti_comission;
            $orderId = (int)$order->id;

            $customer = User::with('parent')->where('id',$order->user_id)->first();
            if($customer){
                $customerName = $customer->name ?? ' a order';

                $spotComissionUser = $customer->parent;
                $sponsorMessage = 'Received '.$spotComission.'৳  from '.$customerName .' (Spot Comission)';
                $spnsorRoyaltiMessage = 'Received '.$sponsorRoyaltiComission.'৳  from '.$customerName .' (Sponsor Royalti Comission)';
                if($spotComissionUser && $spotComissionUser?->status == ACTIVE){
                    $this->sendCommissionToUser($spotComissionUser,$orderId,$spotComission,$sponsorMessage,'SPONSOR');
                }else{
                    $walletservice->sendComissionToFlashWallet($orderId,$spotComission,$sponsorMessage,'SPONSOR',$spotComissionUser?->id);
                }
                $walletservice->sendComissionToFlashWallet($orderId,$sponsorRoyaltiComission,$spnsorRoyaltiMessage,'SPONSOR_ROYALTI');

                $maxUserLimit = maxLevelUser();
                $orderTotalLimit = (float)getValue('min_order_total');
                $teamParentId = $customer->team_parent_id;
                $totalComissionSent = 0;


                if($teamComission > 0  && $teamParentId){
                    for ($i = 1; $i < $maxLevel; $i++) {
                        $user = User::with(['team','orders'=>function($query){
                            $query->where('status',ORDER_DELIVERED)
                            ->whereDate('created_at',Carbon::now());
                        }])->where('id',$teamParentId)->first();

                        //now check if user has package and did he repurchase the package
                        $type = 'unconditional';
                        $orderTotal = $user->orders?->sum('order_total');
                        if($user->team->count() < ($maxUserLimit-1) && $orderTotal >= $orderTotalLimit){
                            $type = 'conditional';
                        }

                        $comissionPercentage =  Comission::where('level',$i)->where('type',$type)->value('comission');
                        $comission = $teamComission*$comissionPercentage/100;
                        $totalComissionSent += $comission;

                        if($user){
                            $message = 'Received '.$comission.'৳ from '.$customerName.' (Team comission)';
                            if($user->status == ACTIVE){
                                $this->sendCommissionToUser($user,$orderId,$comission,$message,'TEAM');
                                if($user->team_parent_id)
                                    $teamParentId = $user->team_parent_id;
                                else
                                    break;
                            }else{
                                $walletservice->sendComissionToFlashWallet($orderId,$comission,$message,'TEAM',$user->id);
                            }
                        }else{
                            break;
                        }
                    }
                }else{
                    $totalComissionLeft = (float)$teamComission-$totalComissionSent;
                    if($totalComissionLeft > 0){
                        $message = $totalComissionLeft.' ৳ left after team comission';
                        $walletservice->sendComissionToFlashWallet($orderId,$totalComissionLeft,$message,'TEAM');
                    }
                }
            }
        }
        return true;

    }

    public function distributeLeadershipnBonus($order){
            $walletservice = new WalletService();
            $maxLevel = maxComissionLevel();
            $leadershipComission =  $order->total_leadership_commission;
            $totalComissionSent = 0;
            $parentId = $order->user->team_parent_id;
            $customer = $order->user;
            $orderId = $order->id;

            if($leadershipComission > 0){
                if($customer){
                    $customerName = $customer->name ?? ' a order';
                    $totalComissionSent = 0;
                    for ($i = 1; $i < $maxLevel; $i++) {
                        $user = User::with(['team','orders'=>function($query){
                            $query->where('status',ORDER_DELIVERED)
                            ->whereDate('created_at',Carbon::now());
                        }])->where('id',$parentId)->first();

                        //now check if user has package and did he repurchase the package
                        // $type = 'unconditional';
                        // $orderTotal = $user->orders?->sum('order_total');
                        // if($user->team->count() < ($maxUserLimit-1) && $orderTotal >= $orderTotalLimit){
                        //     $type = 'conditional';
                        // }

                        $comissionPercentage =  LeadershipLevel::where('level',$i)->value('comission');
                        $comission = $leadershipComission*$comissionPercentage/100;
                        $totalComissionSent += $comission;

                        if($user){
                            $message = 'Received '.$comission.'৳ from '.$customerName.' (Leadership comission)';
                            if($user->status == ACTIVE && $user->leadership_level >= $i){
                                $this->sendCommissionToUser($user,$orderId,$comission,$message,'LEADERSHIP');
                                if($user->team_parent_id)
                                    $parentId = $user->team_parent_id;
                                else
                                    break;
                            }else{
                                $walletservice->sendComissionToFlashWallet($orderId,$comission,$message,'LEADERSHIP',$user->id);
                            }
                        }else{
                            break;
                        }
                    }
                }
                $totalComissionLeft = (float)$leadershipComission-$totalComissionSent;
                if($totalComissionLeft > 0){
                    $message = $totalComissionLeft.' ৳ left after team comission';
                    $walletservice->sendComissionToFlashWallet($orderId,$totalComissionLeft,$message,'LEADERSHIP');
                }
            }
    }
}
