<?php

namespace App\Services;

use ExpoSDK\ExpoMessage;
use ExpoSDK\Expo;
use Illuminate\Support\Facades\Log;

class NotificationService
{
    static function sendNotification($token,$notification,$data){
        $message = (new ExpoMessage($notification))
            ->setData($data)
            ->setChannelId('default')
            ->setBadge(0)
            ->playSound();

        try{
            (new Expo)->send($message)->to($token)->push();
        }catch(\Exception $e){
            Log::error($e->getMessage());
            Log::error('Failed to send notification to token: '.$token);
        }
    }
}
