<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Withdrawal extends Model
{
    use HasFactory;
    protected $table = 'tbl_withdrawal';
    public $timestamps = false;

    public $guarded = [];

    public $appends  = ['status_text','wallet_type_text','type_text'];

    public function scopeFilter($query){
        $status =  request('status');
        if($status){
            $query->where('status',$status);
        }
    }


    public function getStatusTextAttribute(){
        return getWithdrawalStatus($this->status);
    }


    public function getWalletTypeTextAttribute(){
        if($this->wallet_type == CASH_WALLET){
            return 'Cash wallet';
        }else if($this->wallet_type == COMISSION_WALLET){
            return 'Comission wallet';
        }
    }


    public function getTypeTextAttribute(){
        if($this->type == 'agent'){
            return 'Agent';
        }else if($this->type == 'personal'){
            return 'Personal';
        }
    }

    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }


}
