<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $guarded = [];

    public $appends = ['image_url'];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];


    protected $table = 'tbl_users';
    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public function scopeFilter($query){
        $query->whereNull('deleted_at')->latest();
    }

    public function deller(){
        return $this->belongsTo(DellerShop::class,'id','dealer_id');
    }


    public function getImageUrlAttribute(){
        if($this->image){
            return asset('images'.$this->image);
        }else{
            return noImage();
        }
    }

    public function referralChain()
    {
        return $this->hasManyThrough(User::class, User::class, 'parent_id', 'id', 'id', 'parent_id');
    }

    public function getNameAttribute(){
        if($this->first_name && $this->last_name){
            return $this->first_name.' '.$this->last_name;
        }
        return null;
    }
    public function getMobileAttribute(){
        return '+88'.$this->phone;
    }

    public function team(){
        return $this->hasMany(User::class,'team_parent_id','id');
    }

    public function orders(){
        return $this->hasMany(Order::class,'user_id','id');
    }

    public function division(){
        return $this->belongsTo(Division::class,'division_id','id');
    }

    public function district(){
        return $this->belongsTo(District::class,'district_id','id');
    }

    public function upazila(){
        return $this->belongsTo(Upazila::class,'upazila_id','id');
    }

    public function parent(){
        return $this->belongsTo(User::class,'parent_id','id');
    }

    public function sponsors(){
        return $this->hasMany(User::class,'parent_id','id');
    }

    public function sponsorRoyalti(){
        return $this->sponsors()->where('status',1)->where('package_id','>',0)->where('package_expiry_date','>=',Carbon::now());
    }


}
