<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductSubcategory extends Model
{
    use SoftDeletes;
    protected $table = "tbl_product_subcategory";
    public $primaryKey = "id";
    protected $with = ["category"];
    public function scopeFilter($query)
    {
        $subcategory_name_en = request("subcategory_name_en");
        $subcategory_name_bn = request("subcategory_name_bn");
        $status = request("status");
        $category_id = request("category_id");
        if ($subcategory_name_en) {
            $query->where(
                "subcategory_name_en",
                "LIKE",
                "%" . $subcategory_name_en . "%"
            );
        }
        if ($subcategory_name_bn) {
            $query->where(
                "subcategory_name_bn",
                "LIKE",
                "%" . $subcategory_name_bn . "%"
            );
        }
        if ($status) {
            $query->where("status", "LIKE", "%" . $status . "%");
        }
        if ($category_id) {
            $query->where('category_id',$category_id);
        }
    }
    public function category()
    {
        return $this->belongsTo(ProductCategory::class, "category_id", "id");
    }

    public function products()
    {
        return $this->hasMany(ProductBasicInfo::class, "subcategory_id");
    }

    public function basicProducts(){
        return $this->hasMany(ProductBasicInfo::class,'category_id')->where('status',ACTIVE);
    }

    public function getNameAttribute(){
        if(getLang()=='bn')
            return $this->subcategory_name_bn;
        else
            return $this->subcategory_name_en;
    }
}
