<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductColor extends Model
{
    use HasFactory,SoftDeletes;

    public function getImageUrlAttribute()
    {
        if ($this->image) {
            return url("images" . $this->image);
        } else {
            return noImage();
        }
    }

    public function color(){
        return $this->belongsTo(Colors::class,'color_id','id');
    }
}
