<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ProductBasicInfo extends Model
{
    use HasFactory;
    protected $table = 'tbl_product_basic_info';
    public $guarded=[];
    protected $appends = ["thumbnail_url"];

    public function getThumbnailUrlAttribute()
    {
        if ($this->thumbnail) {
            return url("images/" . $this->thumbnail);
        } else {
            return noImage();
        }
    }

    public function scopeFilter($query){
        $brandId = request('brand_id');
        $productId = request('product_id');
        $categoryId = request('category_id');
        $subcategoryId = request('subcategory_id');
        $companyId = request('company_id');
        $status = request('status');

        if($brandId){
            $query->where('brand_id',$brandId);
        }

        if($categoryId){
            $query->where('category_id',$categoryId);
        }

        if($companyId){
            $query->where('company_id',$companyId);
        }

        if($subcategoryId){
            $query->where('subcategory_id',$subcategoryId);
        }

        if($status>-1){
            $query->where('status',$status);
        }

        // if(!$productId){
        //     $query->whereDoesntHave('storeProduct');
        // }
    }

    public function thumbnails():HasMany
    {
        return $this->hasMany(Images::class,'basic_info_id')->where('type',PRODUCT_THUMBNAIL_IMAGE);
    }

    public function images():HasMany
    {
        return $this->hasMany(Images::class,'basic_info_id')->where('type',PRODUCT_IMAGE);
    }

    public function company():BelongsTo
    {
        return $this->belongsTo(Company::class,'company_id');
    }

    public function category():BelongsTo
    {
        return $this->belongsTo(ProductCategory::class, "category_id", "id");
    }

    public function subcategory():BelongsTo
    {
        return $this->belongsTo(ProductSubcategory::class,"subcategory_id","id");
    }

    public function brand():BelongsTo
    {
        return $this->belongsTo(Brands::class,"brand_id","id");
    }

    public function storeProduct():BelongsTo
    {
        $userId = auth('user')->user()->role == SELLER?auth('user')->id():1;
        return $this->belongsTo(Product::class,"id","basic_info_id")->where('user_id',$userId);
    }


    public function getNameAttribute(){
        if(getLang()=='bn'){
            return $this->product_name_bn;
        }else{
            return $this->product_name_en;
        }
    }

}
