<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderItems extends Model
{
    use HasFactory,SoftDeletes;
    protected $table = 'tbl_order_items';
    public $timestamps  = false;
    public $guarded = [];
    public $appends = ['is_refundable','status_text'];
    public function product():BelongsTo
    {
        return $this->belongsTo(Product::class,'product_id');
    }

    public function order():BelongsTo
    {
        return $this->belongsTo(Order::class,'order_id');
    }

    public function color():BelongsTo
    {
        return $this->belongsTo(ProductColor::class,'color_id');
    }

    public function getStatusTextAttribute()
    {
        return getOrderItemStatus($this->status);
    }

    public function shop(){
        return $this->belongsTo(Shop::class,'shop_id');
    }

    public function hub(){
        return $this->belongsTo(DeliveryHub::class,'hub_id');
    }

    public function getIsRefundableAttribute(){
         if(in_array((int)$this->status,notRefundableStatus())){
            return false;
        }else{
            $refundTime = date('Y-m-d H:i:s', strtotime($this->refund_end_time));
            return $refundTime>date('Y-m-d H:i:s')?true:false;
        }
    }
}
