<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;


class Order extends Model
{
    use HasFactory;
    public $guarded = [];
    public $appends = ['status_text','order_date'];

    public function scopeFilter($query){
        $status = request('status');
        $order_from = request('order_from');
        $user_id = request('user_id');
        $hub_id = request('hub_id');

        if($user_id){
            $query->where('user_id',$user_id);
        }

        if($hub_id){
            $query->where('hub_id',$hub_id);
        }


        if($order_from){
            $query->where('order_from',$order_from);
        }

        if($status){
            $query->where('status',$status);
        }
    }
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }

    public function shop(){
        return $this->belongsTo(Shop::class,'shop_id');
    }

    public function vendor(){
        return $this->belongsTo(Vendor::class,'vendor_id');
    }

    public function hub(){
        return $this->belongsTo(DeliveryHub::class,'hub_id');
    }

    public function address(){
        return $this->belongsTo(OrderAddress::class,'id','order_id');
    }

    public function orderItems(){
        return $this->hasMany(OrderItems::class,'order_id');
    }

    // public function items(){
    //     $domain = 'https://'.request()->getHost().'/images';
    //     return $this->hasMany(OrderItems::class,'order_id')
    //     ->leftJoin('tbl_product', 'tbl_product.id', '=', 'tbl_order_items.product_id')
    //     ->select('tbl_product.id','order_id','status','product_name_en','price','discount','size','color','refund_time','thumbnail','qty',DB::raw("product_name_".getLang()." as product_name"));
    // }

    public function orderItemHistory(){
        return $this->hasMany(OrderItemHistory::class,'order_id')->orderBy('id','DESC');
    }

    public function orderStatusHistory(){
        return $this->hasMany(OrderStatusHistory::class,'order_id')->orderBy('id','DESC');
    }

    public function getStatusTextAttribute(){
        if($this->status){
            return getStatus($this->status);
        }
    }
    public function getOrderDateAttribute(){
        if($this->created_at){
            return date('d M Y H:i',strtotime($this->created_at));
        }
    }

    public function scopeSalesReportfilter($query){
        $start_date = request('start_date');
        $end_date = request('end_date');
        $user_id=request('user_id');
        $shop_id = request('shop_id');

        if($start_date){
            $query->where('created_at','>=',$start_date);
        }
        if($end_date){
            $query->where('created_at','<=',$end_date);
        }
        if($user_id){
            $query->where('user_id',$user_id);
        }
        if($shop_id){
            $query->where('shop_id',$shop_id);
        }

    }


    static function distributeReferelBonus($customerId,$spotComission,$teamComission,$orderId){
        if(comissionStatus()){
            $maxLevel = maxComissionLevel();
            $customer = User::where('id',$customerId)->first();
            if($customer){
                $id = $customer->parent_id;
                $customerName = $customer->name ?? ' a order';

                if($spotComission > 0){
                    $spotComissionUser = User::where('id',$id)->first();
                    $message = 'You received '.$spotComission.'৳  from '.$customerName .' (Spot Comission)';
                    if($spotComissionUser && $spotComissionUser->status == ACTIVE){
                        Notification::sendNotification('Received Spot Comission',$message,$spotComissionUser->id);
                        $spotComissionUser->increment('comission_wallet',$spotComission);
                        ComissionWalletHistory::create([
                            'user_id'=>$spotComissionUser->id,
                            'order_id'=>$orderId,
                            'amount'=>$spotComission,
                            'transaction_type'=>1,
                            'message'=>$message,
                            'current_balance'=>$spotComissionUser->comission_wallet
                        ]);
                    }else{
                        AdminWallet::where('id',1)->increment('balance',$spotComission);
                        ComissionWalletHistory::create([
                            'order_id'=>$orderId,
                            'amount'=>$spotComission,
                            'transaction_type'=>1,
                            'message'=>$message,
                            'current_balance'=>AdminWallet::where('id',1)->value('balance'),
                            'user_id'=>0,
                            'for_admin'=>1,
                        ]);
                    }
                }

                $maxUserLimit = maxLevelUser();
                $orderTotalLimit = (float)getValue('min_order_total');
                $teamParentId = $customer->team_parent_id;
                if($teamComission > 0){
                    $totalComissionSent = 0;
                    for ($i = 1; $i < $maxLevel; $i++) {
                        $user = User::with(['team','orders'=>function($query){
                            $query->where('status',ORDER_DELIVERED)
                            ->whereDate('created_at',Carbon::now());
                        }])->where('id',$teamParentId)->first();
                        //count total reffered user
                        $type = 'unconditional';

                        $orderTotal = $user->orders?->sum('order_total');
                        if($user->team->count() < ($maxUserLimit-1) && $orderTotal >= $orderTotalLimit){
                            $type = 'conditional';
                        }
                        $comissionPercentage =  Comission::where('level',$i)->where('type',$type)->value('comission');
                        $comission = $teamComission*$comissionPercentage/100;
                        $totalComissionSent += $comission;
                        if($user){
                            if($user->status == ACTIVE){
                                $message = 'You received '.$comission.'৳ from '.$customerName.' (Team comission)';
                                Notification::sendNotification('Received Team Comission',$message,$user->id);
                                ComissionWalletHistory::create([
                                    'user_id'=>$user->id,
                                    'order_id'=>$orderId,
                                    'amount'=>$comission,
                                    'transaction_type'=>2,
                                    'message'=>$message,
                                    'current_balance'=>$user->comission_wallet,
                                ]);
                                $user->increment('comission_wallet',$comission);
                                if($user->team_parent_id){
                                    $teamParentId = $user->team_parent_id;
                                }else{
                                    break;
                                }
                            }else{
                                AdminWallet::where('id',1)->increment('balance',$comission);
                                ComissionWalletHistory::create([
                                    'order_id'=>$orderId,
                                    'amount'=>$comission,
                                    'transaction_type'=>1,
                                    'message'=>$comission.' ৳ added to admin account because the user status is not active',
                                    'current_balance'=>AdminWallet::where('id',1)->value('balance'),
                                    'user_id'=>0,
                                    'for_admin'=>1,
                                ]);
                            }
                        }else{
                            break;
                        }
                    }

                    $totalComissionLeft = (float)$teamComission-$totalComissionSent;
                    if($totalComissionLeft > 0){
                        AdminWallet::where('id',1)->increment('balance',$totalComissionLeft);
                        ComissionWalletHistory::create([
                            'order_id'=>$orderId,
                            'amount'=>$totalComissionLeft,
                            'transaction_type'=>1,
                            'message'=>$totalComissionLeft.' ৳ left after team comission',
                            'current_balance'=>AdminWallet::where('id',1)->value('balance'),
                            'user_id'=>0,
                            'for_admin'=>1,
                        ]);
                    }
                }
            }
        }
        return true;

    }

}
