<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HubWithdrawal extends Model
{
    use HasFactory;
    // protected $table = 'hub_withdrawals';
    protected $fillable = ['hub_id', 'amount', 'data', 'admin_reason','status','payment_method'];

    public $casts = [
        'data'=>'collection'
    ];

    public function getStatusTextAttribute(){
        if($this->status == HUB_WITHDRAW_REQUEST_PENDING)
            return 'Pending';
        if($this->status == HUB_WITHDRAW_REQUEST_ACCEPTED)
            return 'Accepted';
        if($this->status == HUB_WITHDRAW_REQUEST_REJECTED)
            return 'Rejected';
    }
}
