<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GroupProduct extends Model
{
    use HasFactory;
    public $fillable = ['name_en','name_bn','icon','status','product_ids'];

    public $casts = [
        'product_ids'=>'array'
    ];

    public function getIconUrlAttribute()
    {
        if ($this->icon) {
            return url("images" . $this->icon);
        } else {
            return noImage();
        }
    }

    public function getStatusTextAttribute()
    {
        if($this->status == 1){
            return 'Active';
        }else{
            return 'Inactive';
        }
    }

    public function getNameAttribute(): string
    {
        if(getLang()=='bn'){
            return $this->name_bn;
        }else{
            return $this->name_en;
        }
    }
}
