<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ComissionWalletHistory extends Model
{
    use HasFactory;
    protected $table = 'tbl_comission_wallet_history';
    public $timestamps = false;
    public $guarded = [];


    public function customer(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function hub(){
        return $this->belongsTo(DeliveryHub::class,'hub_id');
    }
    public function order(){
        return $this->belongsTo(Order::class,'order_id');
    }

    public function getCommissionStatusAttribute(){
        if($this->transaction_type  == DELIVERY_COMISSION)
            return 'Delivery Comission';
        else if($this->transaction_type == FUND_TRANSFER)
            return 'Fund Transfer';
        else if($this->transaction_type == WITHDRAWAL)
            return 'Withdraw';
    }

    public function receivedForm(){
        return $this->belongsTo(User::class,'received_from');
    }
}
