<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    protected $table = "tbl_banner";
    public $primaryKey = "id";

    public $guarded =  [];

    public function getBannerImageUrlAttribute()
    {
        if ($this->banner_image) {
            return url("images" . $this->banner_image);
        } else {
            return "https://upload.wikimedia.org/wikipedia/commons/thumb/a/ac/No_image_available.svg/1024px-No_image_available.svg.png";
        }
    }

    public function getStatusTextAttribute(){
        if($this->status == 0){
            return 'Unpublished';
        }else{
            if($this->publish_at && $this->unpublish_at){
                if($this->publish_at > date('Y-m-d')){
                    return 'Scheduled';
                }else if($this->unpublish_at < date('Y-m-d')){
                    return 'Unpublished';
                }else{
                    return 'Published';
                }
            }else{
                return 'Published';
            }
        }
    }
}
