<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Area extends Model
{
    use HasFactory;

    public $fillable = ['division_id','district_id','upazila_id','area_name'];


    public function division(){
        return $this->belongsTo(Division::class,'division_id','id');
    }

    public function district(){
        return $this->belongsTo(Districts::class,'district_id','id');
    }

    public function upazila(){
        return $this->belongsTo(Upazila::class,'upazila_id','id');
    }

}
